/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tamaya.format;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.tamaya.format.ConfigurationData;
import org.apache.tamaya.spi.PropertySource;
import org.apache.tamaya.spi.PropertyValue;

public class FlattenedDefaultPropertySource
implements PropertySource {
    private static final Logger LOG = Logger.getLogger(FlattenedDefaultPropertySource.class.getName());
    private final Map<String, String> properties;
    private final ConfigurationData data;
    private int defaultOrdinal = 0;

    public FlattenedDefaultPropertySource(ConfigurationData data) {
        this.properties = this.populateData(data);
        this.data = data;
    }

    public FlattenedDefaultPropertySource(int defaultOrdinal, ConfigurationData data) {
        this.properties = this.populateData(data);
        this.data = data;
        this.defaultOrdinal = defaultOrdinal;
    }

    protected Map<String, String> populateData(ConfigurationData data) {
        Map<String, String> result = data.getCombinedProperties();
        if (result.isEmpty()) {
            result = data.getDefaultProperties();
        }
        if (result.isEmpty()) {
            result = new HashMap<String, String>();
        }
        if (result.isEmpty()) {
            for (String section : data.getSectionNames()) {
                Map<String, String> sectionMap = data.getSection(section);
                for (Map.Entry<String, String> en : sectionMap.entrySet()) {
                    result.put(section + '.' + en.getKey(), en.getValue());
                }
            }
        }
        return Collections.unmodifiableMap(result);
    }

    public String getName() {
        String name = this.properties.get("[meta].name");
        if (name == null) {
            name = this.data.getResource();
        }
        if (name == null) {
            name = this.getClass().getSimpleName();
        }
        return name;
    }

    public int getOrdinal() {
        String ordinalValue = this.properties.get("tamaya.ordinal");
        if (ordinalValue != null) {
            try {
                return Integer.parseInt(ordinalValue.trim());
            }
            catch (Exception e) {
                LOG.log(Level.WARNING, "Failed to parse Tamaya ordinal from " + this.data.getResource(), e);
            }
        }
        return this.defaultOrdinal;
    }

    public PropertyValue get(String key) {
        return PropertyValue.of((String)key, (String)this.properties.get(key), (String)this.getName());
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public boolean isScannable() {
        return true;
    }
}

