/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tamaya.events.spi;

import java.util.Objects;
import java.util.UUID;
import org.apache.tamaya.events.ConfigEvent;

public abstract class BaseConfigEvent<T>
implements ConfigEvent<T> {
    protected long timestamp = System.currentTimeMillis();
    protected String version = UUID.randomUUID().toString();
    protected final T paylod;
    private final Class<T> type;

    public BaseConfigEvent(T paylod, Class<T> type) {
        this.paylod = Objects.requireNonNull(paylod);
        this.type = Objects.requireNonNull(type);
    }

    @Override
    public Class<T> getResourceType() {
        return this.type;
    }

    @Override
    public T getResource() {
        return this.paylod;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public long getTimestamp() {
        return this.timestamp;
    }

    public String toString() {
        return this.getClass().getSimpleName() + '{' + "timestamp=" + this.timestamp + ", version='" + this.version + '\'' + ", paylod='" + this.paylod + '\'' + '}';
    }
}

