/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tamaya.events.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.tamaya.events.ConfigEvent;
import org.apache.tamaya.events.ConfigEventListener;
import org.apache.tamaya.events.internal.DefaultConfigChangeObserver;
import org.apache.tamaya.events.spi.ConfigEventManagerSpi;
import org.apache.tamaya.spi.ServiceContextManager;

public class DefaultConfigEventManagerSpi
implements ConfigEventManagerSpi {
    private static final Logger LOG = Logger.getLogger(DefaultConfigEventManagerSpi.class.getName());
    private final Map<Class, List<ConfigEventListener>> listeners = new ConcurrentHashMap<Class, List<ConfigEventListener>>();
    private final ExecutorService publisher = Executors.newCachedThreadPool();
    private final DefaultConfigChangeObserver changeObserver = new DefaultConfigChangeObserver();

    public DefaultConfigEventManagerSpi() {
        try {
            for (ConfigEventListener l : ServiceContextManager.getServiceContext().getServices(ConfigEventListener.class)) {
                try {
                    this.addListener(l);
                }
                catch (Exception e) {
                    LOG.log(Level.WARNING, "Failed to load configured listener: " + l.getClass().getName(), e);
                }
            }
        }
        catch (Exception e) {
            LOG.log(Level.WARNING, "Failed to load configured listeners.", e);
        }
    }

    @Override
    public void addListener(ConfigEventListener l) {
        this.addListener(l, ConfigEvent.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends ConfigEvent> void addListener(ConfigEventListener l, Class<T> eventType) {
        List<ConfigEventListener> ls = this.listeners.get(eventType);
        if (ls == null) {
            ls = Collections.synchronizedList(new ArrayList());
            this.listeners.put(eventType, ls);
        }
        List<ConfigEventListener> list = ls;
        synchronized (list) {
            if (!ls.contains(l)) {
                ls.add(l);
            }
        }
    }

    @Override
    public void removeListener(ConfigEventListener l) {
        this.removeListener(l, ConfigEvent.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends ConfigEvent> void removeListener(ConfigEventListener l, Class<T> eventType) {
        List<ConfigEventListener> targets = this.listeners.get(eventType);
        if (targets != null) {
            List<ConfigEventListener> list = targets;
            synchronized (list) {
                targets.remove(l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<? extends ConfigEventListener> getListeners(Class<? extends ConfigEvent> eventType) {
        List<ConfigEventListener> targets = this.listeners.get(eventType);
        if (targets != null) {
            List<ConfigEventListener> list = targets;
            synchronized (list) {
                return new ArrayList<ConfigEventListener>(targets);
            }
        }
        return Collections.emptyList();
    }

    @Override
    public Collection<? extends ConfigEventListener> getListeners() {
        HashSet<ConfigEventListener> targets = new HashSet<ConfigEventListener>();
        for (List<ConfigEventListener> l : this.listeners.values()) {
            targets.addAll(l);
        }
        return targets;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void fireEvent(ConfigEvent<?> event) {
        List<ConfigEventListener> list;
        List<ConfigEventListener> targets = this.listeners.get(event.getClass());
        if (targets != null) {
            list = targets;
            synchronized (list) {
                for (ConfigEventListener l : targets) {
                    l.onConfigEvent(event);
                }
            }
        }
        if ((targets = this.listeners.get(ConfigEvent.class)) != null) {
            list = targets;
            synchronized (list) {
                for (ConfigEventListener l : targets) {
                    l.onConfigEvent(event);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void fireEventAsynch(ConfigEvent<?> event) {
        List<ConfigEventListener> list;
        List<ConfigEventListener> targets = this.listeners.get(event.getClass());
        if (targets != null) {
            list = targets;
            synchronized (list) {
                for (ConfigEventListener l : targets) {
                    this.publisher.execute(new PublishConfigChangeTask(l, event));
                }
            }
        }
        if ((targets = this.listeners.get(ConfigEvent.class)) != null) {
            list = targets;
            synchronized (list) {
                for (ConfigEventListener l : targets) {
                    this.publisher.execute(new PublishConfigChangeTask(l, event));
                }
            }
        }
    }

    @Override
    public long getChangeMonitoringPeriod() {
        return this.changeObserver.getCheckPeriod();
    }

    @Override
    public void setChangeMonitoringPeriod(long millis) {
        this.changeObserver.setCheckPeriod(millis);
    }

    @Override
    public boolean isChangeMonitorActive() {
        return this.changeObserver.isMonitoring();
    }

    @Override
    public void enableChangeMonitor(boolean enable) {
        this.changeObserver.enableMonitoring(enable);
    }

    private static final class PublishConfigChangeTask
    implements Runnable {
        private final ConfigEventListener l;
        private final ConfigEvent<?> changes;

        public PublishConfigChangeTask(ConfigEventListener l, ConfigEvent<?> changes) {
            this.l = Objects.requireNonNull(l);
            this.changes = Objects.requireNonNull(changes);
        }

        @Override
        public void run() {
            this.l.onConfigEvent(this.changes);
        }
    }
}

