/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tamaya.events.internal;

import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Logger;
import org.apache.tamaya.ConfigurationProvider;
import org.apache.tamaya.events.ConfigEventManager;
import org.apache.tamaya.events.ConfigurationChange;
import org.apache.tamaya.events.ConfigurationChangeBuilder;
import org.apache.tamaya.events.FrozenConfiguration;

public class DefaultConfigChangeObserver {
    private static final long START_DELAY = 5000L;
    private static final Logger LOG = Logger.getLogger(DefaultConfigChangeObserver.class.getName());
    private final Timer timer = new Timer("DefaultConfigChangeObserver", true);
    private long checkPeriod = 2000L;
    private volatile FrozenConfiguration lastConfig;
    private volatile boolean running;

    public DefaultConfigChangeObserver() {
        LOG.info("Registering config change observer, rechecking config changes every " + this.checkPeriod + " ms.");
        this.timer.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                if (DefaultConfigChangeObserver.this.running) {
                    DefaultConfigChangeObserver.this.checkConfigurationUpdate();
                }
            }
        }, 5000L, this.checkPeriod);
    }

    public void checkConfigurationUpdate() {
        LOG.finest("Checking configuration for changes...");
        FrozenConfiguration newConfig = FrozenConfiguration.of(ConfigurationProvider.getConfiguration());
        ConfigurationChange changes = this.lastConfig == null ? ConfigurationChangeBuilder.of(newConfig).putAll(newConfig.getProperties()).build() : ConfigurationChangeBuilder.of(this.lastConfig).addChanges(newConfig).build();
        if (!changes.isEmpty()) {
            LOG.info("Identified configuration changes, publishing change event...");
            ConfigEventManager.fireEvent(changes);
        }
    }

    public long getCheckPeriod() {
        return this.checkPeriod;
    }

    public boolean isMonitoring() {
        return this.running;
    }

    public void enableMonitoring(boolean enable) {
        this.running = true;
    }

    public void setCheckPeriod(long checkPeriod) {
        LOG.finest("Resetting check period to " + checkPeriod + " ms, reregistering timer.");
        this.checkPeriod = checkPeriod;
        this.timer.cancel();
        this.timer.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                if (DefaultConfigChangeObserver.this.running) {
                    DefaultConfigChangeObserver.this.checkConfigurationUpdate();
                }
            }
        }, 500L, checkPeriod);
    }
}

