/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tamaya.events.folderobserver;

import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.tamaya.ConfigException;
import org.apache.tamaya.core.propertysource.BasePropertySource;
import org.apache.tamaya.events.ConfigEventManager;
import org.apache.tamaya.events.ConfigurationContextChange;
import org.apache.tamaya.events.ConfigurationContextChangeBuilder;
import org.apache.tamaya.events.folderobserver.FileChangeListener;
import org.apache.tamaya.events.folderobserver.FileChangeObserver;
import org.apache.tamaya.spi.PropertySource;
import org.apache.tamaya.spi.PropertySourceProvider;

public class ObservingPropertySourceProvider
implements PropertySourceProvider,
FileChangeObserver {
    private static final Logger LOG = Logger.getLogger(ObservingPropertySourceProvider.class.getName());
    private final List<PropertySource> propertySources = Collections.synchronizedList(new LinkedList());
    private final ExecutorService executor = Executors.newSingleThreadExecutor();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObservingPropertySourceProvider(Path directory) {
        if (directory == null) {
            directory = this.getDirectory();
        }
        if (directory != null) {
            List<PropertySource> list = this.propertySources;
            synchronized (list) {
                this.propertySources.addAll(this.readConfiguration(directory));
            }
            FileChangeListener runnable = new FileChangeListener(directory, this);
            this.executor.execute(runnable);
        } else {
            this.executor.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<PropertySource> readConfiguration(Path directory) {
        ArrayList<PropertySource> result = new ArrayList<PropertySource>();
        try {
            List<PropertySource> list = this.propertySources;
            synchronized (list) {
                for (Path path : Files.newDirectoryStream(directory, "*")) {
                    result.addAll(this.getPropertySources(path));
                }
                return result;
            }
        }
        catch (IOException e) {
            LOG.log(Level.WARNING, "Failed to read configuration from dir: " + directory, e);
            return result;
        }
    }

    protected Collection<PropertySource> getPropertySources(final Path file) {
        return Arrays.asList(new BasePropertySource(){
            private final Map<String, String> props;
            {
                this.props = ObservingPropertySourceProvider.readProperties(file);
            }

            public Map<String, String> getProperties() {
                return this.props;
            }
        });
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected static Map<String, String> readProperties(Path file) {
        try (InputStream is = file.toUri().toURL().openStream();){
            Properties props = new Properties();
            props.load(is);
            HashMap<String, String> result = new HashMap<String, String>();
            for (Map.Entry<Object, Object> en : props.entrySet()) {
                result.put(String.valueOf(en.getKey()), String.valueOf(en.getValue()));
            }
            HashMap<String, String> hashMap = result;
            return hashMap;
        }
        catch (Exception e) {
            LOG.log(Level.INFO, "Error reading file: " + file.toString() + ", using format: properties", e);
            return Collections.emptyMap();
        }
    }

    private Path getDirectory() {
        Path path;
        String absolutePath = System.getProperty("tamaya.configdir");
        if (null != absolutePath && Files.isDirectory(path = Paths.get(absolutePath, new String[0]), new LinkOption[0])) {
            return path;
        }
        URL resource = ObservingPropertySourceProvider.class.getResource("/META-INF/config/");
        if (null != resource) {
            try {
                return Paths.get(resource.toURI());
            }
            catch (URISyntaxException e) {
                throw new ConfigException("An error to find the directory to watch", (Throwable)e);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void directoryChanged(Path directory) {
        List<PropertySource> list = this.propertySources;
        synchronized (list) {
            ArrayList<PropertySource> existingPropertySources = new ArrayList<PropertySource>(this.propertySources);
            this.propertySources.clear();
            List<PropertySource> sourcesRead = this.readConfiguration(directory);
            this.propertySources.addAll(sourcesRead);
            this.triggerConfigChange(existingPropertySources, this.propertySources);
        }
    }

    private void triggerConfigChange(List<PropertySource> originalPropertySources, List<PropertySource> newPropertySources) {
        ConfigurationContextChangeBuilder b = ConfigurationContextChangeBuilder.of();
        for (PropertySource ps : originalPropertySources) {
            b.removedPropertySource(ps);
        }
        for (PropertySource ps : newPropertySources) {
            b.newPropertySource(ps);
        }
        ConfigurationContextChange changeEvent = b.build();
        LOG.fine("Trigger Config Context Change: " + changeEvent);
        ConfigEventManager.fireEvent(changeEvent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<PropertySource> getPropertySources() {
        List<PropertySource> list = this.propertySources;
        synchronized (list) {
            return new ArrayList<PropertySource>(this.propertySources);
        }
    }
}

