/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tamaya.events;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.tamaya.spi.PropertySource;
import org.apache.tamaya.spi.PropertyValue;

public final class FrozenPropertySource
implements PropertySource,
Serializable {
    private static final long serialVersionUID = -6373137316556444171L;
    private final int ordinal;
    private Map<String, String> properties = new HashMap<String, String>();
    private final String name;

    private FrozenPropertySource(PropertySource propertySource) {
        this.properties.putAll(propertySource.getProperties());
        this.properties.put("[meta]frozenAt", String.valueOf(System.currentTimeMillis()));
        this.properties = Collections.unmodifiableMap(this.properties);
        this.ordinal = propertySource.getOrdinal();
        this.name = propertySource.getName();
    }

    public static FrozenPropertySource of(PropertySource propertySource) {
        if (propertySource instanceof FrozenPropertySource) {
            return (FrozenPropertySource)propertySource;
        }
        return new FrozenPropertySource(propertySource);
    }

    public String getName() {
        return this.name;
    }

    public int getOrdinal() {
        return this.ordinal;
    }

    public PropertyValue get(String key) {
        return PropertyValue.of((String)key, (String)this.properties.get(key), (String)this.getName());
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public boolean isScannable() {
        return true;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FrozenPropertySource)) {
            return false;
        }
        FrozenPropertySource that = (FrozenPropertySource)o;
        return this.ordinal == that.ordinal && this.properties.equals(that.properties);
    }

    public int hashCode() {
        int result = this.ordinal;
        result = 31 * result + this.properties.hashCode();
        return result;
    }

    public String toString() {
        return "FrozenPropertySource{name=" + this.name + ", ordinal=" + this.ordinal + ", properties=" + this.properties + '}';
    }
}

