/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tamaya.events;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.tamaya.ConfigException;
import org.apache.tamaya.ConfigOperator;
import org.apache.tamaya.ConfigQuery;
import org.apache.tamaya.Configuration;
import org.apache.tamaya.ConfigurationProvider;
import org.apache.tamaya.TypeLiteral;
import org.apache.tamaya.functions.ConfigurationFunctions;
import org.apache.tamaya.spi.ConfigurationContext;
import org.apache.tamaya.spi.ConversionContext;
import org.apache.tamaya.spi.PropertyConverter;

public final class FrozenConfiguration
implements Configuration,
Serializable {
    private static final long serialVersionUID = -6373137316556444171L;
    private Map<String, String> properties = new HashMap<String, String>();

    private FrozenConfiguration(Configuration config) {
        this.properties.putAll(config.getProperties());
        this.properties.put("[meta]frozenAt", String.valueOf(System.currentTimeMillis()));
        this.properties = Collections.unmodifiableMap(this.properties);
    }

    public static FrozenConfiguration of(Configuration config) {
        if (config instanceof FrozenConfiguration) {
            return (FrozenConfiguration)config;
        }
        return new FrozenConfiguration(config);
    }

    public String get(String key) {
        return this.properties.get(key);
    }

    public String getOrDefault(String key, String defaultValue) {
        String val = this.get(key);
        if (val == null) {
            return defaultValue;
        }
        return val;
    }

    public <T> T getOrDefault(String key, Class<T> type, T defaultValue) {
        T val = this.get(key, type);
        if (val == null) {
            return defaultValue;
        }
        return val;
    }

    public <T> T get(String key, Class<T> type) {
        return this.get(key, TypeLiteral.of(type));
    }

    public <T> T get(String key, TypeLiteral<T> type) {
        String value = this.get(key);
        if (value != null) {
            List converters = ConfigurationProvider.getConfigurationContext().getPropertyConverters(type);
            ConversionContext context = new ConversionContext.Builder((Configuration)this, ConfigurationProvider.getConfigurationContext(), key, type).build();
            for (PropertyConverter converter : converters) {
                try {
                    Object t = converter.convert(value, context);
                    if (t == null) continue;
                    return (T)t;
                }
                catch (Exception e) {
                    Logger.getLogger(this.getClass().getName()).log(Level.FINEST, "PropertyConverter: " + converter + " failed to convert value: " + value, e);
                }
            }
            throw new ConfigException("Unparseable config value for type: " + type.getRawType().getName() + ": " + key + ", supported formats: " + context.getSupportedFormats());
        }
        return null;
    }

    public <T> T getOrDefault(String key, TypeLiteral<T> type, T defaultValue) {
        T val = this.get(key, type);
        if (val == null) {
            return defaultValue;
        }
        return val;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public Configuration with(ConfigOperator operator) {
        return operator.operate((Configuration)this);
    }

    public <T> T query(ConfigQuery<T> query) {
        return (T)query.query((Configuration)this);
    }

    public ConfigurationContext getContext() {
        return ConfigurationFunctions.emptyConfigurationContext();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FrozenConfiguration that = (FrozenConfiguration)o;
        return this.properties.equals(that.properties);
    }

    public int hashCode() {
        return this.properties.hashCode();
    }

    public String toString() {
        return "FrozenConfiguration{properties=" + this.properties + '}';
    }
}

