/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tamaya.events;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.tamaya.ConfigurationProvider;
import org.apache.tamaya.events.ConfigurationContextChange;
import org.apache.tamaya.events.PropertySourceChange;
import org.apache.tamaya.spi.ConfigurationContext;
import org.apache.tamaya.spi.PropertySource;

public final class ConfigurationContextChangeBuilder {
    final List<PropertySourceChange> changedPropertySources = new ArrayList<PropertySourceChange>();
    String version;
    Long timestamp;
    final ConfigurationContext configurationContext;

    private ConfigurationContextChangeBuilder(ConfigurationContext configurationContext) {
        this.configurationContext = Objects.requireNonNull(configurationContext);
    }

    public static ConfigurationContextChangeBuilder of() {
        return ConfigurationContextChangeBuilder.of(ConfigurationProvider.getConfigurationContext());
    }

    public static ConfigurationContextChangeBuilder of(ConfigurationContext context) {
        return new ConfigurationContextChangeBuilder(context);
    }

    public ConfigurationContextChangeBuilder setVersion(String version) {
        this.version = version;
        return this;
    }

    public ConfigurationContextChangeBuilder setTimestamp(long timestamp) {
        this.timestamp = timestamp;
        return this;
    }

    public ConfigurationContextChangeBuilder newPropertySource(PropertySource propertySource) {
        this.changedPropertySources.add(PropertySourceChange.ofAdded(propertySource));
        return this;
    }

    public ConfigurationContextChangeBuilder removedPropertySource(PropertySource propertySource) {
        this.changedPropertySources.add(PropertySourceChange.ofDeleted(propertySource));
        return this;
    }

    public ConfigurationContextChangeBuilder changedPropertySource(PropertySourceChange propertySourceChange) {
        this.changedPropertySources.add(Objects.requireNonNull(propertySourceChange));
        return this;
    }

    public boolean isEmpty() {
        return this.changedPropertySources.isEmpty();
    }

    public void reset() {
        this.changedPropertySources.clear();
    }

    public ConfigurationContextChange build() {
        return new ConfigurationContextChange(this);
    }

    public String toString() {
        return "ConfigurationContextChangeBuilder [propertySources=" + this.changedPropertySources + "]";
    }
}

