/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tamaya.events;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import org.apache.tamaya.events.ChangeType;
import org.apache.tamaya.events.ConfigEvent;
import org.apache.tamaya.events.ConfigurationContextChangeBuilder;
import org.apache.tamaya.events.PropertySourceChange;
import org.apache.tamaya.spi.ConfigurationContext;
import org.apache.tamaya.spi.PropertySource;

public final class ConfigurationContextChange
implements ConfigEvent<ConfigurationContext>,
Serializable {
    private static final long serialVersionUID = 1L;
    private final List<PropertySourceChange> changedPropertySources = new ArrayList<PropertySourceChange>();
    private String version = UUID.randomUUID().toString();
    private long timestamp = System.currentTimeMillis();
    private final ConfigurationContext configurationContext;

    public static ConfigurationContextChange emptyChangeSet(ConfigurationContext configurationContext) {
        return ConfigurationContextChangeBuilder.of(configurationContext).build();
    }

    ConfigurationContextChange(ConfigurationContextChangeBuilder builder) {
        this.changedPropertySources.addAll(builder.changedPropertySources);
        if (builder.version != null) {
            this.version = builder.version;
        }
        if (builder.timestamp != null) {
            this.timestamp = builder.timestamp;
        }
        this.configurationContext = builder.configurationContext;
    }

    @Override
    public Class<ConfigurationContext> getResourceType() {
        return ConfigurationContext.class;
    }

    @Override
    public ConfigurationContext getResource() {
        return this.configurationContext;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public long getTimestamp() {
        return this.timestamp;
    }

    public Collection<PropertySourceChange> getPropertySourceChanges() {
        return Collections.unmodifiableCollection(this.changedPropertySources);
    }

    public Collection<PropertySourceChange> getPropertySourceUpdates() {
        ArrayList<PropertySourceChange> result = new ArrayList<PropertySourceChange>();
        for (PropertySourceChange pc : this.changedPropertySources) {
            if (pc.getChangeType() != ChangeType.UPDATED) continue;
            result.add(pc);
        }
        return result;
    }

    public Collection<PropertySource> getRemovedPropertySources() {
        ArrayList<PropertySource> result = new ArrayList<PropertySource>();
        for (PropertySourceChange pc : this.changedPropertySources) {
            if (pc.getChangeType() != ChangeType.DELETED) continue;
            result.add(pc.getResource());
        }
        return result;
    }

    public Collection<PropertySource> getAddedPropertySources() {
        ArrayList<PropertySource> result = new ArrayList<PropertySource>();
        for (PropertySourceChange pc : this.changedPropertySources) {
            if (pc.getChangeType() != ChangeType.NEW) continue;
            result.add(pc.getResource());
        }
        return result;
    }

    public Collection<PropertySource> getUpdatedPropertySources() {
        ArrayList<PropertySource> result = new ArrayList<PropertySource>();
        for (PropertySourceChange pc : this.changedPropertySources) {
            if (pc.getChangeType() != ChangeType.UPDATED) continue;
            result.add(pc.getResource());
        }
        return result;
    }

    public boolean isAffected(PropertySource propertySource) {
        for (PropertySourceChange ps : this.changedPropertySources) {
            if (ps.getResource() != propertySource && !ps.getResource().getName().equals(propertySource.getName())) continue;
            return true;
        }
        return false;
    }

    public boolean isEmpty() {
        return this.changedPropertySources.isEmpty();
    }

    public String toString() {
        return "ConfigurationContextChange{changedPropertySources=" + this.changedPropertySources + ", version='" + this.version + '\'' + ", timestamp=" + this.timestamp + '}';
    }
}

