/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tamaya.events;

import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.tamaya.Configuration;
import org.apache.tamaya.ConfigurationProvider;
import org.apache.tamaya.events.ConfigurationChange;

public final class ConfigurationChangeBuilder {
    final SortedMap<String, PropertyChangeEvent> delta = new TreeMap<String, PropertyChangeEvent>();
    final Configuration source;
    String version;
    Long timestamp;

    private ConfigurationChangeBuilder(Configuration configuration) {
        this.source = Objects.requireNonNull(configuration);
    }

    public static ConfigurationChangeBuilder of() {
        return new ConfigurationChangeBuilder(ConfigurationProvider.getConfiguration());
    }

    public static ConfigurationChangeBuilder of(Configuration configuration) {
        return new ConfigurationChangeBuilder(configuration);
    }

    public static Collection<PropertyChangeEvent> compare(Configuration map1, Configuration map2) {
        String val;
        ArrayList<PropertyChangeEvent> changes = new ArrayList<PropertyChangeEvent>();
        for (Map.Entry en : map1.getProperties().entrySet()) {
            val = map2.get((String)en.getKey());
            if (val == null) {
                changes.add(new PropertyChangeEvent(map1, (String)en.getKey(), null, en.getValue()));
                continue;
            }
            if (val.equals(en.getValue())) continue;
            changes.add(new PropertyChangeEvent(map1, (String)en.getKey(), val, en.getValue()));
        }
        for (Map.Entry en : map2.getProperties().entrySet()) {
            val = map1.get((String)en.getKey());
            if (val == null) {
                changes.add(new PropertyChangeEvent(map1, (String)en.getKey(), null, en.getValue()));
                continue;
            }
            if (val.equals(en.getValue())) continue;
            changes.add(new PropertyChangeEvent(map1, (String)en.getKey(), val, en.getValue()));
        }
        return changes;
    }

    public ConfigurationChangeBuilder setVersion(String version) {
        this.version = version;
        return this;
    }

    public ConfigurationChangeBuilder setTimestamp(long timestamp) {
        this.timestamp = timestamp;
        return this;
    }

    public ConfigurationChangeBuilder addChanges(Configuration newState) {
        for (PropertyChangeEvent c : ConfigurationChangeBuilder.compare(newState, this.source)) {
            this.delta.put(c.getPropertyName(), c);
        }
        return this;
    }

    public ConfigurationChangeBuilder addChange(String key, String value) {
        this.delta.put(key, new PropertyChangeEvent(this.source, key, this.source.get(key), value));
        return this;
    }

    public String get(String key) {
        PropertyChangeEvent change = (PropertyChangeEvent)this.delta.get(key);
        if (change != null && change.getNewValue() != null) {
            return (String)change.getNewValue();
        }
        return null;
    }

    public ConfigurationChangeBuilder removeKey(String key, String ... otherKeys) {
        String oldValue = this.source.get(key);
        if (oldValue == null) {
            this.delta.remove(key);
        }
        this.delta.put(key, new PropertyChangeEvent(this.source, key, oldValue, null));
        for (String addKey : otherKeys) {
            oldValue = this.source.get(addKey);
            if (oldValue == null) {
                this.delta.remove(addKey);
            }
            this.delta.put(addKey, new PropertyChangeEvent(this.source, addKey, oldValue, null));
        }
        return this;
    }

    public ConfigurationChangeBuilder putAll(Map<String, String> changes) {
        for (Map.Entry<String, String> en : changes.entrySet()) {
            this.delta.put(en.getKey(), new PropertyChangeEvent(this.source, en.getKey(), null, en.getValue()));
        }
        return this;
    }

    public ConfigurationChangeBuilder removeAllKeys() {
        this.delta.clear();
        for (Map.Entry en : this.source.getProperties().entrySet()) {
            this.delta.put((String)en.getKey(), new PropertyChangeEvent(this.source, (String)en.getKey(), en.getValue(), null));
        }
        return this;
    }

    public boolean isEmpty() {
        return this.delta.isEmpty();
    }

    public void reset() {
        this.delta.clear();
    }

    public ConfigurationChange build() {
        return new ConfigurationChange(this);
    }

    public String toString() {
        return "ConfigurationChangeSetBuilder [config=" + this.source + ", " + ", delta=" + this.delta + "]";
    }
}

