/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tamaya.events;

import java.beans.PropertyChangeEvent;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.apache.tamaya.Configuration;
import org.apache.tamaya.events.ConfigEvent;
import org.apache.tamaya.events.ConfigurationChangeBuilder;
import org.apache.tamaya.events.FrozenConfiguration;

public final class ConfigurationChange
implements ConfigEvent<Configuration>,
Serializable {
    private static final long serialVersionUID = 1L;
    private final FrozenConfiguration configuration;
    private String version = UUID.randomUUID().toString();
    private long timestamp = System.currentTimeMillis();
    private final Map<String, PropertyChangeEvent> changes = new HashMap<String, PropertyChangeEvent>();

    public static ConfigurationChange emptyChangeSet(Configuration configuration) {
        return ConfigurationChangeBuilder.of(configuration).build();
    }

    ConfigurationChange(ConfigurationChangeBuilder builder) {
        this.configuration = FrozenConfiguration.of(builder.source);
        for (PropertyChangeEvent ev : builder.delta.values()) {
            this.changes.put(ev.getPropertyName(), ev);
        }
        if (builder.version != null) {
            this.version = builder.version;
        }
        if (builder.timestamp != null) {
            this.timestamp = builder.timestamp;
        }
    }

    @Override
    public Class<Configuration> getResourceType() {
        return Configuration.class;
    }

    @Override
    public Configuration getResource() {
        return this.configuration;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public long getTimestamp() {
        return this.timestamp;
    }

    public Collection<PropertyChangeEvent> getChanges() {
        return Collections.unmodifiableCollection(this.changes.values());
    }

    public int getRemovedSize() {
        int removedCount = 0;
        for (PropertyChangeEvent ev : this.changes.values()) {
            if (ev.getNewValue() != null) continue;
            ++removedCount;
        }
        return removedCount;
    }

    public int getAddedSize() {
        int addedCount = 0;
        for (PropertyChangeEvent ev : this.changes.values()) {
            if (ev.getOldValue() != null || ev.getNewValue() == null) continue;
            ++addedCount;
        }
        return addedCount;
    }

    public int getUpdatedSize() {
        int updatedCount = 0;
        for (PropertyChangeEvent ev : this.changes.values()) {
            if (ev.getOldValue() == null || ev.getNewValue() == null) continue;
            ++updatedCount;
        }
        return updatedCount;
    }

    public boolean isRemoved(String key) {
        PropertyChangeEvent change = this.changes.get(key);
        return change != null && change.getNewValue() == null;
    }

    public boolean isAdded(String key) {
        PropertyChangeEvent change = this.changes.get(key);
        return change != null && change.getOldValue() == null;
    }

    public boolean isUpdated(String key) {
        PropertyChangeEvent change = this.changes.get(key);
        return change != null && change.getOldValue() != null && change.getNewValue() != null;
    }

    public boolean isKeyAffected(String key) {
        PropertyChangeEvent change = this.changes.get(key);
        return change != null && change.getNewValue() != null;
    }

    public boolean isEmpty() {
        return this.changes.isEmpty();
    }

    public String toString() {
        return "ConfigurationChange{configuration=" + this.configuration + ", version='" + this.version + '\'' + ", timestamp=" + this.timestamp + '}';
    }
}

