/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tamaya.events;

import java.util.Collection;
import org.apache.tamaya.ConfigException;
import org.apache.tamaya.events.ConfigEvent;
import org.apache.tamaya.events.ConfigEventListener;
import org.apache.tamaya.events.spi.ConfigEventManagerSpi;
import org.apache.tamaya.spi.ServiceContextManager;

public final class ConfigEventManager {
    private static final ConfigEventManagerSpi SPI = (ConfigEventManagerSpi)ServiceContextManager.getServiceContext().getService(ConfigEventManagerSpi.class);

    private ConfigEventManager() {
    }

    public static void addListener(ConfigEventListener l) {
        if (SPI == null) {
            throw new ConfigException("No SPI registered for " + ConfigEventManager.class.getName());
        }
        SPI.addListener(l);
    }

    public static <T extends ConfigEvent> void addListener(ConfigEventListener l, Class<T> eventType) {
        if (SPI == null) {
            throw new ConfigException("No SPI registered for " + ConfigEventManager.class.getName());
        }
        SPI.addListener(l);
    }

    public static void removeListener(ConfigEventListener l) {
        if (SPI == null) {
            throw new ConfigException("No SPI registered for " + ConfigEventManager.class.getName());
        }
        SPI.removeListener(l);
    }

    public static <T extends ConfigEvent> void removeListener(ConfigEventListener l, Class<T> eventType) {
        if (SPI == null) {
            throw new ConfigException("No SPI registered for " + ConfigEventManager.class.getName());
        }
        SPI.removeListener(l);
    }

    public static <T extends ConfigEvent> Collection<? extends ConfigEventListener> getListeners(Class<T> type) {
        return SPI.getListeners(type);
    }

    public static <T extends ConfigEvent> Collection<? extends ConfigEventListener> getListeners() {
        return SPI.getListeners();
    }

    public static <T> void fireEvent(ConfigEvent<?> event) {
        SPI.fireEvent(event);
    }

    public static <T> void fireEventAsynch(ConfigEvent<?> event) {
        SPI.fireEventAsynch(event);
    }

    public static void enableChangeMonitoring(boolean enable) {
        SPI.enableChangeMonitor(enable);
    }

    public static boolean isChangeMonitoring() {
        return SPI.isChangeMonitorActive();
    }

    public long getChangeMonitoringPeriod() {
        return SPI.getChangeMonitoringPeriod();
    }

    public void setChangeMonitoringPeriod(long millis) {
        SPI.setChangeMonitoringPeriod(millis);
    }
}

