/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tamaya.functions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.tamaya.ConfigurationProvider;
import org.apache.tamaya.functions.EnrichedPropertySource;
import org.apache.tamaya.functions.Predicate;
import org.apache.tamaya.spi.PropertySource;
import org.apache.tamaya.spi.PropertyValue;

public final class PropertySourceFunctions {
    private static final PropertySource EMPTY_PROPERTYSOURCE = new PropertySource(){

        public int getOrdinal() {
            return 0;
        }

        public String getName() {
            return "<empty>";
        }

        public PropertyValue get(String key) {
            return null;
        }

        public Map<String, String> getProperties() {
            return Collections.emptyMap();
        }

        public boolean isScannable() {
            return true;
        }

        public String toString() {
            return "PropertySource<empty>";
        }
    };

    private PropertySourceFunctions() {
    }

    public static boolean isKeyInSection(String key, String sectionKey) {
        int lastIndex = key.lastIndexOf(46);
        String curAreaKey = lastIndex > 0 ? key.substring(0, lastIndex) : "";
        return curAreaKey.equals(sectionKey);
    }

    public static boolean isKeyInSections(String key, String ... sectionKeys) {
        for (String areaKey : sectionKeys) {
            if (!PropertySourceFunctions.isKeyInSection(key, areaKey)) continue;
            return true;
        }
        return false;
    }

    public static Set<String> sections(Map<String, String> properties) {
        HashSet<String> areas = new HashSet<String>();
        for (String s : properties.keySet()) {
            int index = s.lastIndexOf(46);
            if (index > 0) {
                areas.add(s.substring(0, index));
                continue;
            }
            areas.add("<root>");
        }
        return areas;
    }

    public static Set<String> transitiveSections(Map<String, String> properties) {
        HashSet<String> transitiveAreas = new HashSet<String>();
        for (String s : PropertySourceFunctions.sections(properties)) {
            int index = s.lastIndexOf(46);
            if (index < 0) {
                transitiveAreas.add("<root>");
                continue;
            }
            while (index > 0) {
                s = s.substring(0, index);
                transitiveAreas.add(s);
                index = s.lastIndexOf(46);
            }
        }
        return transitiveAreas;
    }

    public static Set<String> sections(Map<String, String> properties, Predicate<String> predicate) {
        TreeSet<String> treeSet = new TreeSet<String>();
        for (String area : PropertySourceFunctions.sections(properties)) {
            if (!predicate.test(area)) continue;
            treeSet.add(area);
        }
        return treeSet;
    }

    public static Set<String> transitiveSections(Map<String, String> properties, Predicate<String> predicate) {
        TreeSet<String> treeSet = new TreeSet<String>();
        for (String area : PropertySourceFunctions.transitiveSections(properties)) {
            if (!predicate.test(area)) continue;
            treeSet.add(area);
        }
        return treeSet;
    }

    public static Map<String, String> sectionsRecursive(Map<String, String> properties, String ... sectionKeys) {
        return PropertySourceFunctions.sectionRecursive(properties, true, sectionKeys);
    }

    public static Map<String, String> sectionRecursive(Map<String, String> properties, boolean stripKeys, String ... sectionKeys) {
        HashMap<String, String> result = new HashMap<String, String>(properties.size());
        if (stripKeys) {
            for (Map.Entry<String, String> en : properties.entrySet()) {
                if (!PropertySourceFunctions.isKeyInSections(en.getKey(), sectionKeys)) continue;
                result.put(en.getKey(), en.getValue());
            }
        } else {
            for (Map.Entry<String, String> en : properties.entrySet()) {
                if (!PropertySourceFunctions.isKeyInSections(en.getKey(), sectionKeys)) continue;
                result.put(PropertySourceFunctions.stripSectionKeys(en.getKey(), sectionKeys), en.getValue());
            }
        }
        return result;
    }

    static String stripSectionKeys(String key, String ... areaKeys) {
        for (String areaKey : areaKeys) {
            if (!key.startsWith(areaKey + '.')) continue;
            return key.substring(areaKey.length() + 1);
        }
        return key;
    }

    public static PropertySource addItems(PropertySource propertySource, Map<String, String> items, boolean override) {
        return new EnrichedPropertySource(propertySource, items, override);
    }

    public static PropertySource addItems(PropertySource propertySource, Map<String, String> items) {
        return PropertySourceFunctions.addItems(propertySource, items, false);
    }

    public static PropertySource replaceItems(PropertySource propertySource, Map<String, String> items) {
        return PropertySourceFunctions.addItems(propertySource, items, true);
    }

    public static PropertySource emptyPropertySource() {
        return EMPTY_PROPERTYSOURCE;
    }

    public static Collection<? extends PropertySource> findPropertySourcesByName(String expression) {
        ArrayList<PropertySource> result = new ArrayList<PropertySource>();
        for (PropertySource src : ConfigurationProvider.getConfigurationContext().getPropertySources()) {
            if (!src.getName().matches(expression)) continue;
            result.add(src);
        }
        return result;
    }

    public static <T> Collection<T> getPropertySources(Class<T> type) {
        ArrayList<PropertySource> result = new ArrayList<PropertySource>();
        for (PropertySource src : ConfigurationProvider.getConfigurationContext().getPropertySources()) {
            if (!type.isAssignableFrom(src.getClass())) continue;
            result.add(src);
        }
        return result;
    }

    public static <T> T getPropertySource(Class<T> type) {
        for (PropertySource src : ConfigurationProvider.getConfigurationContext().getPropertySources()) {
            if (!type.isAssignableFrom(src.getClass())) continue;
            return (T)src;
        }
        return null;
    }
}

