/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tamaya.functions;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.tamaya.functions.KeyMapper;
import org.apache.tamaya.spi.PropertySource;
import org.apache.tamaya.spi.PropertyValue;

class MappedPropertySource
implements PropertySource {
    private static final long serialVersionUID = 8690637705511432083L;
    private final KeyMapper keyMapper;
    private final PropertySource propertySource;

    public MappedPropertySource(PropertySource config, KeyMapper keyMapper) {
        this.propertySource = Objects.requireNonNull(config);
        this.keyMapper = Objects.requireNonNull(keyMapper);
    }

    public int getOrdinal() {
        return this.propertySource.getOrdinal();
    }

    public String getName() {
        return this.propertySource.getName() + "[mapped]";
    }

    public Map<String, String> getProperties() {
        HashMap<String, String> result = new HashMap<String, String>();
        Map map = this.propertySource.getProperties();
        for (Map.Entry en : map.entrySet()) {
            String targetKey = this.keyMapper.mapKey((String)en.getKey());
            if (targetKey == null) continue;
            result.put(targetKey, (String)en.getValue());
        }
        return result;
    }

    public boolean isScannable() {
        return this.propertySource.isScannable();
    }

    public PropertyValue get(String key) {
        return PropertyValue.of((String)key, (String)this.getProperties().get(key), (String)this.getName());
    }
}

