/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tamaya.functions;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Logger;
import org.apache.tamaya.ConfigOperator;
import org.apache.tamaya.ConfigQuery;
import org.apache.tamaya.Configuration;
import org.apache.tamaya.TypeLiteral;
import org.apache.tamaya.functions.KeyMapper;
import org.apache.tamaya.spi.ConfigurationContext;

class MappedConfiguration
implements Configuration {
    private static final Logger LOG = Logger.getLogger(MappedConfiguration.class.getName());
    private final Configuration baseConfiguration;
    private final KeyMapper keyMapper;
    private final String mapType;

    MappedConfiguration(Configuration baseConfiguration, KeyMapper keyMapper, String mapType) {
        this.baseConfiguration = Objects.requireNonNull(baseConfiguration);
        this.keyMapper = Objects.requireNonNull(keyMapper);
        this.mapType = mapType != null ? mapType : this.keyMapper.toString();
    }

    public String get(String key) {
        return this.get(key, String.class);
    }

    public String getOrDefault(String key, String defaultValue) {
        String val = this.get(key);
        if (val == null) {
            return defaultValue;
        }
        return val;
    }

    public <T> T getOrDefault(String key, Class<T> type, T defaultValue) {
        T val = this.get(key, type);
        if (val == null) {
            return defaultValue;
        }
        return val;
    }

    public <T> T get(String key, Class<T> type) {
        return this.get(key, TypeLiteral.of(type));
    }

    public <T> T get(String key, TypeLiteral<T> type) {
        String targetKey = this.keyMapper.mapKey(key);
        if (targetKey != null) {
            return (T)this.baseConfiguration.get(targetKey, type);
        }
        LOG.finest("Configuration property hidden by KeyMapper, key=" + key + ", mapper=" + this.keyMapper + ", config=" + this);
        return null;
    }

    public <T> T getOrDefault(String key, TypeLiteral<T> type, T defaultValue) {
        T val = this.get(key, type);
        if (val == null) {
            return defaultValue;
        }
        return val;
    }

    public Map<String, String> getProperties() {
        Map baseProps = this.baseConfiguration.getProperties();
        HashMap<String, String> props = new HashMap<String, String>(baseProps.size());
        for (Map.Entry en : baseProps.entrySet()) {
            String targetKey = this.keyMapper.mapKey((String)en.getKey());
            if (targetKey == null) continue;
            props.put(targetKey, (String)en.getValue());
        }
        return props;
    }

    public Configuration with(ConfigOperator operator) {
        return operator.operate((Configuration)this);
    }

    public <T> T query(ConfigQuery<T> query) {
        return (T)query.query((Configuration)this);
    }

    public ConfigurationContext getContext() {
        return this.baseConfiguration.getContext();
    }

    public String toString() {
        return "FilteredConfiguration{baseConfiguration=" + this.baseConfiguration + ", mapping=" + this.mapType + '}';
    }
}

