/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tamaya.functions;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.tamaya.functions.Predicate;
import org.apache.tamaya.spi.PropertySource;
import org.apache.tamaya.spi.PropertyValue;

class FilteredPropertySource
implements PropertySource {
    private final PropertySource baseSource;
    private final Predicate<String> filter;

    public FilteredPropertySource(PropertySource baseSource, Predicate<String> filter) {
        this.baseSource = Objects.requireNonNull(baseSource);
        this.filter = Objects.requireNonNull(filter);
    }

    public int getOrdinal() {
        return this.baseSource.getOrdinal();
    }

    public String getName() {
        return this.baseSource.getName();
    }

    public PropertyValue get(String key) {
        return PropertyValue.of((String)key, (String)this.getProperties().get(key), (String)this.getName());
    }

    public Map<String, String> getProperties() {
        HashMap<String, String> result = new HashMap<String, String>();
        for (Map.Entry en : this.baseSource.getProperties().entrySet()) {
            if (!this.filter.test((String)en.getKey())) continue;
            result.put((String)en.getKey(), (String)en.getValue());
        }
        return result;
    }

    public boolean isScannable() {
        return this.baseSource.isScannable();
    }

    public String toString() {
        return "FilteredPropertySource{baseSource=" + this.baseSource + ", filter=" + this.filter + '}';
    }
}

