/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tamaya.functions;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.tamaya.ConfigOperator;
import org.apache.tamaya.ConfigQuery;
import org.apache.tamaya.Configuration;
import org.apache.tamaya.TypeLiteral;
import org.apache.tamaya.functions.PropertyMatcher;
import org.apache.tamaya.spi.ConfigurationContext;

class FilteredConfiguration
implements Configuration {
    private final Configuration baseConfiguration;
    private final PropertyMatcher matcher;
    private final String filterType;

    FilteredConfiguration(Configuration baseConfiguration, PropertyMatcher matcher, String filterType) {
        this.baseConfiguration = Objects.requireNonNull(baseConfiguration);
        this.matcher = Objects.requireNonNull(matcher);
        this.filterType = filterType != null ? filterType : this.matcher.toString();
    }

    public String get(String key) {
        return this.get(key, String.class);
    }

    public String getOrDefault(String key, String defaultValue) {
        String val = this.get(key);
        if (val == null) {
            return defaultValue;
        }
        return val;
    }

    public <T> T getOrDefault(String key, Class<T> type, T defaultValue) {
        T val = this.get(key, type);
        if (val == null) {
            return defaultValue;
        }
        return val;
    }

    public <T> T get(String key, Class<T> type) {
        return this.get(key, TypeLiteral.of(type));
    }

    public <T> T get(String key, TypeLiteral<T> type) {
        String value = this.baseConfiguration.get(key);
        if (this.matcher.test(key, value)) {
            return (T)this.baseConfiguration.get(key, type);
        }
        return null;
    }

    public <T> T getOrDefault(String key, TypeLiteral<T> type, T defaultValue) {
        T val = this.get(key, type);
        if (val == null) {
            return defaultValue;
        }
        return val;
    }

    public Map<String, String> getProperties() {
        HashMap<String, String> result = new HashMap<String, String>();
        for (Map.Entry en : this.baseConfiguration.getProperties().entrySet()) {
            if (!this.matcher.test((String)en.getKey(), (String)en.getValue())) continue;
            result.put((String)en.getKey(), (String)en.getValue());
        }
        return result;
    }

    public Configuration with(ConfigOperator operator) {
        return null;
    }

    public <T> T query(ConfigQuery<T> query) {
        return (T)query.query((Configuration)this);
    }

    public ConfigurationContext getContext() {
        return this.baseConfiguration.getContext();
    }

    public String toString() {
        return "FilteredConfiguration{baseConfiguration=" + this.baseConfiguration + ", matcher=" + this.filterType + '}';
    }
}

