/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tamaya.functions;

import java.net.Inet4Address;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.tamaya.ConfigOperator;
import org.apache.tamaya.ConfigQuery;
import org.apache.tamaya.Configuration;
import org.apache.tamaya.TypeLiteral;
import org.apache.tamaya.functions.CombinedConfiguration;
import org.apache.tamaya.functions.ConfigWrappingPropertySource;
import org.apache.tamaya.functions.EnrichedConfiguration;
import org.apache.tamaya.functions.FilteredConfiguration;
import org.apache.tamaya.functions.KeyMapper;
import org.apache.tamaya.functions.MappedConfiguration;
import org.apache.tamaya.functions.Predicate;
import org.apache.tamaya.functions.PropertyMatcher;
import org.apache.tamaya.functions.PropertySourceFunctions;
import org.apache.tamaya.spi.ConfigurationContext;
import org.apache.tamaya.spi.ConfigurationContextBuilder;
import org.apache.tamaya.spi.PropertyConverter;
import org.apache.tamaya.spi.PropertyFilter;
import org.apache.tamaya.spi.PropertySource;
import org.apache.tamaya.spi.PropertyValueCombinationPolicy;

public final class ConfigurationFunctions {
    private static final Logger LOG = Logger.getLogger(ConfigurationFunctions.class.getName());
    private static final Configuration EMPTY_CONFIGURATION = new Configuration(){

        public String get(String key) {
            return null;
        }

        public String getOrDefault(String key, String defaultValue) {
            return defaultValue;
        }

        public <T> T getOrDefault(String key, Class<T> type, T defaultValue) {
            return defaultValue;
        }

        public <T> T get(String key, Class<T> type) {
            return null;
        }

        public <T> T get(String key, TypeLiteral<T> type) {
            return null;
        }

        public <T> T getOrDefault(String key, TypeLiteral<T> type, T defaultValue) {
            return defaultValue;
        }

        public Map<String, String> getProperties() {
            return Collections.emptyMap();
        }

        public Configuration with(ConfigOperator operator) {
            return operator.operate((Configuration)this);
        }

        public <T> T query(ConfigQuery<T> query) {
            return (T)query.query((Configuration)this);
        }

        public ConfigurationContext getContext() {
            return EMPTY_CONFIGURATION_CONTEXT;
        }

        public String toString() {
            return "Configuration<empty>";
        }
    };
    private static final ConfigurationContext EMPTY_CONFIGURATION_CONTEXT = new ConfigurationContext(){

        public void addPropertySources(PropertySource ... propertySourcesToAdd) {
        }

        public List<PropertySource> getPropertySources() {
            return Collections.emptyList();
        }

        public <T> void addPropertyConverter(TypeLiteral<T> typeToConvert, PropertyConverter<T> propertyConverter) {
        }

        public Map<TypeLiteral<?>, List<PropertyConverter<?>>> getPropertyConverters() {
            return Collections.emptyMap();
        }

        public <T> List<PropertyConverter<T>> getPropertyConverters(TypeLiteral<T> type) {
            return Collections.emptyList();
        }

        public List<PropertyFilter> getPropertyFilters() {
            return Collections.emptyList();
        }

        public PropertyValueCombinationPolicy getPropertyValueCombinationPolicy() {
            return PropertyValueCombinationPolicy.DEFAULT_OVERRIDING_COLLECTOR;
        }

        public ConfigurationContextBuilder toBuilder() {
            throw new UnsupportedOperationException("Cannot build from ConfigurationContext.EMPTY.");
        }

        public String toString() {
            return "ConfigurationContext.EMPTY";
        }
    };

    private ConfigurationFunctions() {
    }

    public static ConfigOperator filter(final PropertyMatcher filter) {
        return new ConfigOperator(){

            public Configuration operate(Configuration config) {
                return new FilteredConfiguration(config, filter, "FilterClass: " + filter.getClass().getName());
            }
        };
    }

    public static ConfigOperator map(final KeyMapper keyMapper) {
        return new ConfigOperator(){

            public Configuration operate(Configuration config) {
                return new MappedConfiguration(config, keyMapper, null);
            }
        };
    }

    public static ConfigOperator section(String areaKey) {
        return ConfigurationFunctions.section(areaKey, false);
    }

    public static ConfigOperator section(final String areaKey, final boolean stripKeys) {
        return new ConfigOperator(){

            public Configuration operate(Configuration config) {
                FilteredConfiguration filtered = new FilteredConfiguration(config, new PropertyMatcher(){

                    @Override
                    public boolean test(String k, String v) {
                        return ConfigurationFunctions.isKeyInSection(k, areaKey);
                    }
                }, "section: " + areaKey);
                if (stripKeys) {
                    return new MappedConfiguration(filtered, new KeyMapper(){

                        @Override
                        public String mapKey(String key) {
                            return key.substring(areaKey.length());
                        }
                    }, "stripped");
                }
                return filtered;
            }
        };
    }

    public static boolean isKeyInSection(String key, String sectionKey) {
        return sectionKey.isEmpty() || key.startsWith(sectionKey);
    }

    public static boolean isKeyInSections(String key, String ... sectionKeys) {
        for (String areaKey : sectionKeys) {
            if (!ConfigurationFunctions.isKeyInSection(key, areaKey)) continue;
            return true;
        }
        return false;
    }

    public static ConfigQuery<Set<String>> sections() {
        return new ConfigQuery<Set<String>>(){

            public Set<String> query(Configuration config) {
                TreeSet<String> areas = new TreeSet<String>();
                for (String s : config.getProperties().keySet()) {
                    int index = s.lastIndexOf(46);
                    if (index <= 0) continue;
                    areas.add(s.substring(0, index));
                }
                return areas;
            }
        };
    }

    public static ConfigQuery<Set<String>> transitiveSections() {
        return new ConfigQuery<Set<String>>(){

            public Set<String> query(Configuration config) {
                TreeSet<String> transitiveAreas = new TreeSet<String>();
                for (String s : (Set)config.query(ConfigurationFunctions.sections())) {
                    transitiveAreas.add(s);
                    int index = s.lastIndexOf(46);
                    while (index > 0) {
                        s = s.substring(0, index);
                        transitiveAreas.add(s);
                        index = s.lastIndexOf(46);
                    }
                }
                return transitiveAreas;
            }
        };
    }

    public static ConfigQuery<Set<String>> sections(final Predicate<String> predicate) {
        return new ConfigQuery<Set<String>>(){

            public Set<String> query(Configuration config) {
                TreeSet<String> result = new TreeSet<String>();
                for (String s : (Set)ConfigurationFunctions.sections().query(config)) {
                    if (!predicate.test(s)) continue;
                    result.add(s);
                }
                return result;
            }
        };
    }

    public static ConfigQuery<Set<String>> transitiveSections(final Predicate<String> predicate) {
        return new ConfigQuery<Set<String>>(){

            public Set<String> query(Configuration config) {
                TreeSet<String> result = new TreeSet<String>();
                for (String s : (Set)ConfigurationFunctions.transitiveSections().query(config)) {
                    if (!predicate.test(s)) continue;
                    result.add(s);
                }
                return result;
            }
        };
    }

    public static ConfigOperator sectionsRecursive(String ... sectionKeys) {
        return ConfigurationFunctions.sectionRecursive(false, sectionKeys);
    }

    public static Configuration combine(String configName, Configuration ... configs) {
        return new CombinedConfiguration(configName, configs);
    }

    public static PropertySource propertySourceFrom(String name, int ordinal, Configuration config) {
        return new ConfigWrappingPropertySource(name, ordinal, config);
    }

    public static ConfigOperator sectionRecursive(final boolean stripKeys, final String ... sectionKeys) {
        return new ConfigOperator(){

            public Configuration operate(Configuration config) {
                FilteredConfiguration filtered = new FilteredConfiguration(config, new PropertyMatcher(){

                    @Override
                    public boolean test(String k, String v) {
                        return ConfigurationFunctions.isKeyInSections(k, sectionKeys);
                    }
                }, "sections: " + Arrays.toString(sectionKeys));
                if (stripKeys) {
                    return new MappedConfiguration(filtered, new KeyMapper(){

                        @Override
                        public String mapKey(String key) {
                            return PropertySourceFunctions.stripSectionKeys(key, sectionKeys);
                        }
                    }, "stripped");
                }
                return filtered;
            }
        };
    }

    public static ConfigQuery<String> jsonInfo() {
        return ConfigurationFunctions.jsonInfo(null);
    }

    public static ConfigQuery<String> jsonInfo(final Map<String, String> info) {
        return new ConfigQuery<String>(){

            public String query(Configuration config) {
                TreeMap<String, String> props = new TreeMap<String, String>(config.getProperties());
                props.put("__timestamp", String.valueOf(System.currentTimeMillis()));
                if (info != null) {
                    for (Map.Entry en : info.entrySet()) {
                        props.put("__" + ConfigurationFunctions.escape((String)en.getKey()), ConfigurationFunctions.escape((String)en.getValue()));
                    }
                }
                StringBuilder builder = new StringBuilder(400).append("{\n");
                for (Map.Entry en : props.entrySet()) {
                    builder.append("  \"").append(ConfigurationFunctions.escape((String)en.getKey())).append("\": \"").append(ConfigurationFunctions.escape((String)en.getValue())).append("\",\n");
                }
                if (builder.toString().endsWith(",\n")) {
                    builder.setLength(builder.length() - 2);
                    builder.append('\n');
                }
                builder.append("}\n");
                return builder.toString();
            }
        };
    }

    public static ConfigQuery<String> xmlInfo() {
        return ConfigurationFunctions.xmlInfo(null);
    }

    public static ConfigQuery<String> xmlInfo(final Map<String, String> info) {
        return new ConfigQuery<String>(){

            public String query(Configuration config) {
                TreeMap<String, String> props = new TreeMap<String, String>(config.getProperties());
                props.put("__timestamp", String.valueOf(System.currentTimeMillis()));
                if (info != null) {
                    for (Map.Entry en : info.entrySet()) {
                        props.put("__" + ConfigurationFunctions.escape((String)en.getKey()), ConfigurationFunctions.escape((String)en.getValue()));
                    }
                }
                StringBuilder builder = new StringBuilder(400);
                builder.append("<configuration>\n");
                for (Map.Entry en : props.entrySet()) {
                    builder.append("  <entry key=\"" + ConfigurationFunctions.escape((String)en.getKey()) + "\">" + ConfigurationFunctions.escape((String)en.getValue()) + "</entry>\n");
                }
                builder.append("</configuration>\n");
                return builder.toString();
            }
        };
    }

    public static ConfigQuery<String> textInfo() {
        return ConfigurationFunctions.textInfo(null);
    }

    public static ConfigQuery<String> textInfo(final Map<String, String> info) {
        return new ConfigQuery<String>(){

            public String query(Configuration config) {
                TreeMap<String, String> props = new TreeMap<String, String>(config.getProperties());
                props.put("__timestamp", String.valueOf(System.currentTimeMillis()));
                if (info != null) {
                    for (Map.Entry en : info.entrySet()) {
                        props.put("__" + ConfigurationFunctions.escape((String)en.getKey()), ConfigurationFunctions.escape((String)en.getValue()));
                    }
                }
                StringBuilder builder = new StringBuilder(400).append("Configuration:\n");
                for (Map.Entry en : props.entrySet()) {
                    builder.append("  " + ConfigurationFunctions.escape((String)en.getKey()) + ": " + ConfigurationFunctions.escape((String)en.getValue()).replace("\n", "\n     ") + ",\n");
                }
                if (builder.toString().endsWith(",\n")) {
                    builder.setLength(builder.length() - 2);
                }
                builder.append("\n");
                return builder.toString();
            }
        };
    }

    public static ConfigOperator addItems(final Map<String, Object> items, final boolean override) {
        return new ConfigOperator(){

            public Configuration operate(Configuration config) {
                return new EnrichedConfiguration(config, items, override);
            }
        };
    }

    public static ConfigOperator addItems(Map<String, Object> items) {
        return ConfigurationFunctions.addItems(items, false);
    }

    public static ConfigOperator replaceItems(Map<String, Object> items) {
        return ConfigurationFunctions.addItems(items, true);
    }

    public static ConfigQuery<String> htmlInfo() {
        return ConfigurationFunctions.htmlInfo(null);
    }

    public static ConfigQuery<String> htmlInfo(final Map<String, String> info) {
        return new ConfigQuery<String>(){

            public String query(Configuration config) {
                StringBuilder builder = new StringBuilder();
                ConfigurationFunctions.addHeader(builder);
                builder.append("<pre>\n").append((String)ConfigurationFunctions.textInfo(info).query(config)).append("</pre>\n");
                ConfigurationFunctions.addFooter(builder);
                return builder.toString();
            }
        };
    }

    private static void addFooter(StringBuilder b) {
        b.append("</body>\n</html>\n");
    }

    private static void addHeader(StringBuilder b) {
        String host = "unknown";
        try {
            host = Inet4Address.getLocalHost().getHostName();
        }
        catch (Exception e) {
            LOG.log(Level.INFO, "Failed to lookup hostname.", e);
        }
        b.append("<html>\n<head><title>System Configuration</title></head>\n<body>\n<h1>System Configuration</h1>\n<p>This view shows the system configuration of " + host + " at " + new Date() + ".</p>");
    }

    private static String escape(String text) {
        return text.replace("\t", "\\t").replace("\"", "\\\"");
    }

    public static Configuration emptyConfiguration() {
        return EMPTY_CONFIGURATION;
    }

    public static ConfigurationContext emptyConfigurationContext() {
        return EMPTY_CONFIGURATION_CONTEXT;
    }
}

