/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tamaya.management;

import java.util.Map;
import java.util.Set;
import org.apache.tamaya.Configuration;
import org.apache.tamaya.ConfigurationProvider;
import org.apache.tamaya.functions.ConfigurationFunctions;
import org.apache.tamaya.management.ManagedConfigMBean;

public class ManagedConfig
implements ManagedConfigMBean {
    private ClassLoader classLoader = Thread.currentThread().getContextClassLoader();

    public ManagedConfig() {
        if (this.classLoader == null) {
            this.classLoader = ManagedConfigMBean.class.getClassLoader();
        }
    }

    @Override
    public String getJsonConfigurationInfo() {
        return (String)this.getConfigurationInternal().query(ConfigurationFunctions.jsonInfo());
    }

    @Override
    public String getXmlConfigurationInfo() {
        return (String)this.getConfigurationInternal().query(ConfigurationFunctions.xmlInfo());
    }

    @Override
    public Map<String, String> getConfiguration() {
        return this.getConfigurationInternal().getProperties();
    }

    @Override
    public Map<String, String> getSection(String area, boolean recursive) {
        return this.getConfigurationInternal().with(ConfigurationFunctions.section((String)area, (boolean)recursive)).getProperties();
    }

    @Override
    public Set<String> getSections() {
        return (Set)this.getConfigurationInternal().query(ConfigurationFunctions.sections());
    }

    @Override
    public Set<String> getTransitiveSections() {
        return (Set)this.getConfigurationInternal().query(ConfigurationFunctions.transitiveSections());
    }

    @Override
    public boolean isAreaExisting(String area) {
        return !this.getConfigurationInternal().with(ConfigurationFunctions.section((String)area)).getProperties().isEmpty();
    }

    @Override
    public boolean isAreaEmpty(String area) {
        return this.getSection(area, true).isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Configuration getConfigurationInternal() {
        ClassLoader currentCL = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.classLoader);
            Configuration configuration = ConfigurationProvider.getConfiguration();
            return configuration;
        }
        finally {
            Thread.currentThread().setContextClassLoader(currentCL);
        }
    }
}

