/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tamaya.management;

import java.lang.management.ManagementFactory;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.tamaya.management.ManagedConfigMBean;
import org.apache.tamaya.spi.ServiceContextManager;

public class ConfigManagementSupport {
    private static final Logger LOG = Logger.getLogger(ConfigManagementSupport.class.getName());

    private ConfigManagementSupport() {
    }

    private static ManagedConfigMBean createMBean() {
        return (ManagedConfigMBean)ServiceContextManager.getServiceContext().getService(ManagedConfigMBean.class);
    }

    public static ObjectName registerMBean() {
        return ConfigManagementSupport.registerMBean(null);
    }

    public static ObjectName registerMBean(String context) {
        try {
            ManagedConfigMBean configMbean = ConfigManagementSupport.createMBean();
            if (configMbean == null) {
                return null;
            }
            MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
            ObjectName on = context == null ? new ObjectName("org.apache.tamaya.managemet:type=ManagedConfigMBean") : new ObjectName("org.apache.tamaya.management:type=ManagedConfigMBean,context=" + context);
            try {
                mbs.getMBeanInfo(on);
                LOG.info("Cannot register mbean " + on + ": already existing.");
                return on;
            }
            catch (InstanceNotFoundException e) {
                LOG.info("Registering mbean " + on + "...");
                mbs.registerMBean(configMbean, on);
                return on;
            }
        }
        catch (Exception e) {
            LOG.log(Level.WARNING, "Failed to register ManagedConfigMBean.", e);
            return null;
        }
    }

    public static ObjectName unregisterMBean() {
        return ConfigManagementSupport.unregisterMBean(null);
    }

    public static ObjectName unregisterMBean(String context) {
        try {
            MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
            ObjectName on = context == null ? new ObjectName("org.apache.tamaya.managemet:type=ManagedConfigMBean") : new ObjectName("org.apache.tamaya.management:type=ManagedConfigMBean,context=" + context);
            try {
                mbs.unregisterMBean(on);
                LOG.info("Unregistered mbean " + on + ".");
                return on;
            }
            catch (InstanceNotFoundException e) {
                LOG.log(Level.INFO, "Unregistering mbean " + on + " failed.", e);
            }
        }
        catch (Exception e) {
            LOG.log(Level.WARNING, "Failed to unregister ManagedConfigMBean.", e);
        }
        return null;
    }
}

