/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tamaya.resource.internal;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.URL;
import java.util.Arrays;
import java.util.Objects;

class VfsSupport {
    private static final String VFS3_PKG = "org.jboss.vfs.";
    private static final String VFS_PROTOCOL = "VFS";
    private static Method methodGetRootUrl = null;
    private static Method methodToUrl;
    private static Method methodGetPathName;
    private static Class<?> fileVisitorInterface;
    private static Method methodVisit;
    private static Field visitorAttributesField;
    private static Method methodGetPhysicalFile;

    private VfsSupport() {
    }

    static void visit(Object resource, InvocationHandler visitor) throws IOException {
        Object visitorProxy = Proxy.newProxyInstance(fileVisitorInterface.getClassLoader(), new Class[]{fileVisitorInterface}, visitor);
        VfsSupport.invokeVfsMethod(methodVisit, resource, visitorProxy);
    }

    private static Object invokeVfsMethod(Method method, Object target, Object ... args) throws IOException {
        try {
            return method.invoke(target, args);
        }
        catch (Exception ex) {
            throw new IOException("Failed to evaluated method: " + method, ex);
        }
    }

    static URL getURL(Object vfsResource) throws IOException {
        return (URL)VfsSupport.invokeVfsMethod(methodToUrl, vfsResource, new Object[0]);
    }

    static Object getRelative(URL url) throws IOException {
        return VfsSupport.invokeVfsMethod(methodGetRootUrl, null, url);
    }

    static File getFile(Object vfsResource) throws IOException {
        return (File)VfsSupport.invokeVfsMethod(methodGetPhysicalFile, vfsResource, new Object[0]);
    }

    static Object getRoot(URL url) throws IOException {
        return VfsSupport.invokeVfsMethod(methodGetRootUrl, null, url);
    }

    static Object getVisitorAttributes() {
        return VfsSupport.readField(visitorAttributesField, null);
    }

    static String getPath(Object resource) {
        try {
            return (String)methodGetPathName.invoke(resource, new Object[0]);
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to get path name - " + resource, e);
        }
    }

    private static Method findMethod(Class<?> clazz, String name, Class<?> ... paramTypes) {
        Objects.requireNonNull(clazz, "Class must not be null");
        Objects.requireNonNull(name, "Method name must not be null");
        for (Class<?> searchType = clazz; searchType != null; searchType = searchType.getSuperclass()) {
            Method[] methods;
            for (Method method : methods = searchType.isInterface() ? searchType.getMethods() : searchType.getDeclaredMethods()) {
                if (!name.equals(method.getName()) || paramTypes != null && !Arrays.equals(paramTypes, method.getParameterTypes())) continue;
                return method;
            }
        }
        return null;
    }

    private static Object readField(Field field, Object target) {
        try {
            if (!field.isAccessible()) {
                field.setAccessible(true);
            }
            return field.get(target);
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to read field: " + field.toGenericString(), e);
        }
    }

    private static Field findField(Class<?> clazz, String name) {
        Objects.requireNonNull(clazz, "Class must not be null");
        Objects.requireNonNull(name, "Name must not be null.");
        for (Class<?> searchType = clazz; !Object.class.equals(searchType) && searchType != null; searchType = searchType.getSuperclass()) {
            Field[] fields;
            for (Field field : fields = searchType.getDeclaredFields()) {
                if (!name.equals(field.getName())) continue;
                return field;
            }
        }
        return null;
    }

    static {
        visitorAttributesField = null;
        methodGetPhysicalFile = null;
        ClassLoader loader = VfsSupport.class.getClassLoader();
        try {
            Class<?> vfsClass = loader.loadClass("org.jboss.vfs.VFS");
            methodGetRootUrl = VfsSupport.findMethod(vfsClass, "getChild", URL.class);
            Class<?> virtualFile = loader.loadClass("org.jboss.vfs.VirtualFile");
            methodToUrl = VfsSupport.findMethod(virtualFile, "toURL", new Class[0]);
            methodGetPathName = VfsSupport.findMethod(virtualFile, "getPathName", new Class[0]);
            methodGetPhysicalFile = VfsSupport.findMethod(virtualFile, "getPhysicalFile", new Class[0]);
            fileVisitorInterface = loader.loadClass("org.jboss.vfs.VirtualFileVisitor");
            methodVisit = VfsSupport.findMethod(virtualFile, "visit", fileVisitorInterface);
            Class<?> visitorAttributesClass = loader.loadClass("org.jboss.vfs.VisitorAttributes");
            visitorAttributesField = VfsSupport.findField(visitorAttributesClass, "RECURSE");
        }
        catch (ClassNotFoundException ex) {
            throw new IllegalStateException("JBoss VFS not available.", ex);
        }
    }
}

