/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tamaya.resource.internal;

import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.logging.Logger;
import javax.annotation.Priority;
import org.apache.tamaya.resource.ResourceLocator;
import org.apache.tamaya.resource.internal.ClasspathCollector;
import org.apache.tamaya.resource.internal.FileCollector;

@Priority(value=100)
public class PathResourceLocator
implements ResourceLocator {
    private static final Logger LOG = Logger.getLogger(PathResourceLocator.class.getName());

    @Override
    public Collection<URL> lookup(ClassLoader classLoader, String expression) {
        try {
            Collection<URL> found = FileCollector.collectFiles(expression);
            if (found.isEmpty()) {
                found = new ClasspathCollector(classLoader).collectFiles(expression);
            }
            return found;
        }
        catch (RuntimeException e) {
            LOG.finest("Failed to load resource from CP: " + expression);
            return Collections.emptySet();
        }
    }
}

