/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tamaya.resource.internal;

import java.util.ArrayList;
import java.util.List;

final class Locator {
    private final List<String> tokens;

    Locator(List<String> tokens) {
        this.tokens = tokens;
    }

    public static Locator of(String expression) {
        ArrayList<String> expressions = new ArrayList<String>();
        for (String expr : expression.split("/")) {
            if (expr.length() == 0) {
                expressions.add("/");
                continue;
            }
            expressions.add(expr);
        }
        return new Locator(expressions);
    }

    public String getRootPath() {
        StringBuilder sj = new StringBuilder();
        for (String token : this.tokens) {
            if (this.containsPlaceholder(token)) break;
            if (sj.length() != 0) {
                sj.append('/');
            }
            sj.append(token);
        }
        return sj.toString();
    }

    public String getSubPath() {
        StringBuilder sj = new StringBuilder();
        for (String token : this.getSubPathTokens()) {
            if (sj.length() != 0) {
                sj.append('/');
            }
            sj.append(token);
        }
        return sj.toString();
    }

    public List<String> getSubPathTokens() {
        ArrayList<String> subTokens = new ArrayList<String>();
        boolean subTokensStarted = false;
        for (String token : this.tokens) {
            if (subTokensStarted) {
                subTokens.add(token);
                continue;
            }
            if (!this.containsPlaceholder(token)) continue;
            subTokensStarted = true;
            subTokens.add(token);
        }
        return subTokens;
    }

    public String getPath() {
        StringBuilder sj = new StringBuilder();
        for (String token : this.tokens) {
            if (sj.length() != 0) {
                sj.append('/');
            }
            sj.append(token);
        }
        return sj.toString();
    }

    private boolean containsPlaceholder(String token) {
        return token.contains("*") || token.contains("?");
    }

    public String toString() {
        return "Locator: " + this.getPath();
    }
}

