/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tamaya.resource.internal;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.logging.Logger;
import javax.annotation.Priority;
import org.apache.tamaya.resource.ResourceLocator;

@Priority(value=90)
public class ClassPathResourceLocator
implements ResourceLocator {
    private static final Logger LOG = Logger.getLogger(ClassPathResourceLocator.class.getName());

    @Override
    public Collection<URL> lookup(ClassLoader classLoader, String expression) {
        ArrayList<URL> resources = new ArrayList<URL>();
        try {
            Enumeration<URL> urls = classLoader.getResources(expression);
            while (urls.hasMoreElements()) {
                URL url = urls.nextElement();
                resources.add(url);
            }
            return resources;
        }
        catch (IOException | RuntimeException e) {
            LOG.finest("Failed to load resource from CP: " + expression);
            return Collections.emptySet();
        }
    }
}

