/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tamaya.resource;

import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.tamaya.resource.ConfigResources;
import org.apache.tamaya.spi.PropertySource;
import org.apache.tamaya.spi.PropertySourceProvider;
import org.apache.tamaya.spi.PropertyValue;

public abstract class AbstractPathPropertySourceProvider
implements PropertySourceProvider {
    private static final Logger LOG = Logger.getLogger(AbstractPathPropertySourceProvider.class.getName());
    private String[] resourcePaths;

    public AbstractPathPropertySourceProvider(String ... resourcePaths) {
        if (resourcePaths.length == 0) {
            throw new IllegalArgumentException("At least one resource path should be configured.");
        }
        this.resourcePaths = (String[])resourcePaths.clone();
    }

    public Collection<PropertySource> getPropertySources() {
        ArrayList<PropertySource> propertySources = new ArrayList<PropertySource>();
        for (String resource : this.resourcePaths) {
            try {
                Collection<URL> resources = ConfigResources.getResourceResolver().getResources(resource);
                for (URL url : resources) {
                    try {
                        Collection<PropertySource> propertySourcesToInclude = this.getPropertySources(url);
                        if (propertySourcesToInclude == null) continue;
                        propertySources.addAll(propertySourcesToInclude);
                    }
                    catch (Exception e) {
                        LOG.log(Level.WARNING, "Failed to read configuration from " + url, e);
                    }
                }
            }
            catch (Exception e) {
                LOG.log(Level.SEVERE, "Invalid resource path: " + resource, e);
            }
        }
        return propertySources;
    }

    protected abstract Collection<PropertySource> getPropertySources(URL var1);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static PropertySource createPropertiesPropertySource(URL url) {
        Properties props = new Properties();
        try (InputStream is = url.openStream();){
            props.load(is);
            PropertiesBasedPropertySource propertiesBasedPropertySource = new PropertiesBasedPropertySource(url.toString(), props);
            return propertiesBasedPropertySource;
        }
        catch (Exception e) {
            LOG.log(Level.WARNING, "Failed to read properties from " + url, e);
            return null;
        }
    }

    private static final class PropertiesBasedPropertySource
    implements PropertySource {
        private final String name;
        private final Map<String, String> properties = new HashMap<String, String>();

        public PropertiesBasedPropertySource(String name, Properties props) {
            this.name = name;
            for (Map.Entry<Object, Object> en : props.entrySet()) {
                this.properties.put(en.getKey().toString(), String.valueOf(en.getValue()));
            }
        }

        public PropertiesBasedPropertySource(String name, Map<String, String> props) {
            this.name = Objects.requireNonNull(name);
            this.properties.putAll(props);
        }

        public int getOrdinal() {
            PropertyValue configuredOrdinal = this.get("tamaya.ordinal");
            if (configuredOrdinal != null) {
                try {
                    return Integer.parseInt(configuredOrdinal.getValue());
                }
                catch (Exception e) {
                    Logger.getLogger(this.getClass().getName()).log(Level.WARNING, "Configured Ordinal is not an int number: " + configuredOrdinal, e);
                }
            }
            return this.getDefaultOrdinal();
        }

        public int getDefaultOrdinal() {
            return 0;
        }

        public String getName() {
            return this.name;
        }

        public PropertyValue get(String key) {
            return PropertyValue.of((String)key, (String)this.getProperties().get(key), (String)this.getName());
        }

        public Map<String, String> getProperties() {
            return this.properties;
        }

        public boolean isScannable() {
            return false;
        }

        public String toString() {
            return "PropertiesBasedPropertySource[" + this.name + ']';
        }
    }
}

