/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tamaya.resolver.internal;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Priority;
import org.apache.tamaya.resolver.spi.ExpressionResolver;
import org.apache.tamaya.spi.ServiceContextManager;

@Priority(value=300)
public final class ResourceResolver
implements ExpressionResolver {
    private final Logger LOG = Logger.getLogger(ResourceResolver.class.getName());
    private static final boolean IS_RESOURCE_MODULE_AVAILABLE = ResourceResolver.checkResourceModule();

    private static boolean checkResourceModule() {
        try {
            Class.forName("org.apache.tamaya.resource.ResourceResolver", false, ResourceResolver.class.getClassLoader());
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public String getResolverPrefix() {
        return "resource:";
    }

    @Override
    public String evaluate(String expression) {
        ArrayList<ClassLoader> classLoaders = new ArrayList<ClassLoader>();
        for (ClassLoader cl : new ClassLoader[]{Thread.currentThread().getContextClassLoader(), this.getClass().getClassLoader(), ClassLoader.getSystemClassLoader()}) {
            if (classLoaders.contains(cl)) continue;
            classLoaders.add(cl);
        }
        return this.readURL(expression, classLoaders);
    }

    /*
     * Exception decompiling
     */
    private String readURL(String expression, List<ClassLoader> classLoaders) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private URL getUrl(String expression, List<ClassLoader> classLoaders) {
        if (IS_RESOURCE_MODULE_AVAILABLE) {
            org.apache.tamaya.resource.ResourceResolver resolver = (org.apache.tamaya.resource.ResourceResolver)ServiceContextManager.getServiceContext().getService(org.apache.tamaya.resource.ResourceResolver.class);
            for (ClassLoader cl : classLoaders) {
                Collection resources = resolver.getResources(cl, new String[]{expression});
                if (resources.isEmpty()) continue;
                if (resources.size() != 1) {
                    this.LOG.log(Level.WARNING, "Unresolvable expression (ambiguous resource): " + expression);
                    return null;
                }
                return (URL)resources.iterator().next();
            }
        } else {
            for (ClassLoader cl : classLoaders) {
                Enumeration<URL> found;
                ArrayList<URL> resources = new ArrayList<URL>();
                try {
                    found = cl.getResources(expression);
                }
                catch (Exception e) {
                    this.LOG.log(Level.SEVERE, "Error resolving expression: " + expression, e);
                    continue;
                }
                while (found.hasMoreElements()) {
                    resources.add(found.nextElement());
                }
                if (resources.isEmpty()) continue;
                if (resources.size() != 1) {
                    this.LOG.log(Level.WARNING, "Unresolvable expression (ambiguous resource): " + expression);
                    return null;
                }
                return (URL)resources.get(0);
            }
            if (expression.contains("*") || expression.contains("?")) {
                this.LOG.warning("Rouse not found: " + expression + "(Hint: expression contains expression" + " placeholders, but resource module is not loaded.");
            }
        }
        return null;
    }
}

