/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tamaya.resolver.internal;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Priority;
import org.apache.tamaya.resolver.spi.ExpressionResolver;
import org.apache.tamaya.resource.ResourceResolver;
import org.apache.tamaya.spi.ServiceContextManager;

@Priority(value=400)
public final class FileResolver
implements ExpressionResolver {
    private final Logger LOG = Logger.getLogger(FileResolver.class.getName());
    private static final boolean IS_RESOURCE_MODULE_AVAILABLE = FileResolver.checkResourceModule();

    private static boolean checkResourceModule() {
        try {
            Class.forName("org.apache.tamaya.resource.ResourceResolver.", false, FileResolver.class.getClassLoader());
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public String getResolverPrefix() {
        return "file:";
    }

    /*
     * Exception decompiling
     */
    @Override
    public String evaluate(String expression) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private URL getUrl(String expression) {
        if (IS_RESOURCE_MODULE_AVAILABLE) {
            ResourceResolver resolver = (ResourceResolver)ServiceContextManager.getServiceContext().getService(ResourceResolver.class);
            Collection resources = resolver.getResources(new String[]{"file:" + expression});
            if (!resources.isEmpty()) {
                if (resources.size() != 1) {
                    this.LOG.log(Level.WARNING, "Unresolvable expression (ambiguous resource): " + expression);
                    return null;
                }
                return (URL)resources.iterator().next();
            }
        } else {
            File file = new File(expression);
            if (file.exists()) {
                try {
                    return file.toURI().toURL();
                }
                catch (MalformedURLException e) {
                    this.LOG.log(Level.WARNING, "Unresolvable expression (cannot convert file to URL): " + expression, e);
                }
            }
        }
        return null;
    }
}

