/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tamaya.resolver.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Priority;
import org.apache.tamaya.resolver.spi.ExpressionEvaluator;
import org.apache.tamaya.resolver.spi.ExpressionResolver;
import org.apache.tamaya.spi.ServiceContextManager;

@Priority(value=10000)
public class DefaultExpressionEvaluator
implements ExpressionEvaluator {
    private static final Logger LOG = Logger.getLogger(DefaultExpressionEvaluator.class.getName());
    private final List<ExpressionResolver> resolvers = new ArrayList<ExpressionResolver>();
    private static final Comparator<ExpressionResolver> RESOLVER_COMPARATOR = new Comparator<ExpressionResolver>(){

        @Override
        public int compare(ExpressionResolver o1, ExpressionResolver o2) {
            return DefaultExpressionEvaluator.compareExpressionResolver(o1, o2);
        }
    };

    public DefaultExpressionEvaluator() {
        for (ExpressionResolver resolver : ServiceContextManager.getServiceContext().getServices(ExpressionResolver.class)) {
            this.resolvers.add(resolver);
        }
        Collections.sort(this.resolvers, RESOLVER_COMPARATOR);
    }

    private static int compareExpressionResolver(ExpressionResolver res1, ExpressionResolver res2) {
        int ord2;
        Priority prio1 = res1.getClass().getAnnotation(Priority.class);
        Priority prio2 = res2.getClass().getAnnotation(Priority.class);
        int ord1 = prio1 != null ? prio1.value() : 0;
        int n = ord2 = prio2 != null ? prio2.value() : 0;
        if (ord1 < ord2) {
            return -1;
        }
        if (ord1 > ord2) {
            return 1;
        }
        return res1.getClass().getName().compareTo(res2.getClass().getName());
    }

    @Override
    public String evaluateExpression(String key, String value) {
        if (value == null) {
            return null;
        }
        StringTokenizer tokenizer = new StringTokenizer(value, "${}", true);
        StringBuilder resolvedValue = new StringBuilder();
        StringBuilder current = new StringBuilder();
        block6: while (tokenizer.hasMoreTokens()) {
            String token;
            switch (token = tokenizer.nextToken()) {
                case "$": {
                    String nextToken;
                    String string = nextToken = tokenizer.hasMoreTokens() ? tokenizer.nextToken() : "";
                    if (!"{".equals(nextToken)) {
                        current.append(token);
                        current.append(nextToken);
                        continue block6;
                    }
                    if (value.indexOf(125) <= 0) {
                        current.append(token);
                        current.append(nextToken);
                        continue block6;
                    }
                    String subExpression = this.parseSubExpression(tokenizer, value);
                    current.append(this.evaluateInternal(subExpression));
                    continue block6;
                }
            }
            current.append(token);
        }
        if (current.length() > 0) {
            resolvedValue.append((CharSequence)current);
        }
        return resolvedValue.toString();
    }

    private String parseSubExpression(StringTokenizer tokenizer, String valueToBeFiltered) {
        StringBuilder expression = new StringBuilder();
        boolean escaped = false;
        block12: while (tokenizer.hasMoreTokens()) {
            String token;
            switch (token = tokenizer.nextToken()) {
                case "\\": {
                    if (!escaped) {
                        escaped = true;
                        continue block12;
                    }
                    expression.append(token);
                    escaped = false;
                    continue block12;
                }
                case "{": {
                    if (!escaped) {
                        LOG.warning("Ignoring not escaped '{' in : " + valueToBeFiltered);
                    }
                    expression.append(token);
                    escaped = false;
                    continue block12;
                }
                case "$": {
                    if (!escaped) {
                        LOG.warning("Ignoring not escaped '$' in : " + valueToBeFiltered);
                    }
                    expression.append(token);
                    escaped = false;
                    continue block12;
                }
                case "}": {
                    if (escaped) {
                        expression.append(token);
                        escaped = false;
                        continue block12;
                    }
                    return expression.toString();
                }
            }
            expression.append(token);
            escaped = false;
        }
        LOG.warning("Invalid expression syntax in: " + valueToBeFiltered + ", expression does not close!");
        return valueToBeFiltered;
    }

    private String evaluateInternal(String unresolvedExpression) {
        String value = null;
        for (ExpressionResolver resolver : this.resolvers) {
            if (!unresolvedExpression.startsWith(resolver.getResolverPrefix())) continue;
            value = resolver.evaluate(unresolvedExpression.substring(resolver.getResolverPrefix().length()));
            break;
        }
        if (value == null) {
            for (ExpressionResolver resolver : this.resolvers) {
                try {
                    value = resolver.evaluate(unresolvedExpression);
                    if (value == null) continue;
                    return value;
                }
                catch (Exception e) {
                    LOG.log(Level.WARNING, "Error during expression resolution from " + resolver, e);
                }
            }
        }
        if (value == null) {
            LOG.log(Level.WARNING, "Unresolvable expression encountered " + unresolvedExpression);
            value = "?{" + unresolvedExpression + '}';
        }
        return value;
    }
}

