/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.test.impl;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.core.spi.Manager;
import org.jboss.arquillian.core.spi.ManagerBuilder;
import org.jboss.arquillian.core.spi.NonManagedObserver;
import org.jboss.arquillian.core.spi.ServiceLoader;
import org.jboss.arquillian.core.spi.Validate;
import org.jboss.arquillian.test.impl.TestExecutionDeciderComparator;
import org.jboss.arquillian.test.spi.LifecycleMethodExecutor;
import org.jboss.arquillian.test.spi.TestMethodExecutor;
import org.jboss.arquillian.test.spi.TestResult;
import org.jboss.arquillian.test.spi.TestRunnerAdaptor;
import org.jboss.arquillian.test.spi.event.suite.After;
import org.jboss.arquillian.test.spi.event.suite.AfterClass;
import org.jboss.arquillian.test.spi.event.suite.AfterSuite;
import org.jboss.arquillian.test.spi.event.suite.Before;
import org.jboss.arquillian.test.spi.event.suite.BeforeClass;
import org.jboss.arquillian.test.spi.event.suite.BeforeSuite;
import org.jboss.arquillian.test.spi.event.suite.Test;
import org.jboss.arquillian.test.spi.event.suite.TestLifecycleEvent;
import org.jboss.arquillian.test.spi.execution.ExecutionDecision;
import org.jboss.arquillian.test.spi.execution.SkippedTestExecutionException;
import org.jboss.arquillian.test.spi.execution.TestExecutionDecider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EventTestRunnerAdaptor
implements TestRunnerAdaptor {
    private Manager manager;

    public EventTestRunnerAdaptor(ManagerBuilder builder) {
        Validate.notNull(builder, "ManagerBuilder must be specified");
        this.manager = builder.create();
        this.manager.start();
    }

    public EventTestRunnerAdaptor(Manager manager) {
        Validate.notNull(manager, "Manager must be specified");
        this.manager = manager;
    }

    @Override
    public void beforeSuite() throws Exception {
        this.manager.fire(new BeforeSuite());
    }

    @Override
    public void afterSuite() throws Exception {
        this.manager.fire(new AfterSuite());
    }

    @Override
    public void beforeClass(Class<?> testClass, LifecycleMethodExecutor executor) throws Exception {
        Validate.notNull(testClass, "TestClass must be specified");
        this.manager.fire(new BeforeClass(testClass, executor));
    }

    @Override
    public void afterClass(Class<?> testClass, LifecycleMethodExecutor executor) throws Exception {
        Validate.notNull(testClass, "TestClass must be specified");
        this.manager.fire(new AfterClass(testClass, executor));
    }

    @Override
    public void before(Object testInstance, Method testMethod, LifecycleMethodExecutor executor) throws Exception {
        Validate.notNull(testInstance, "TestInstance must be specified");
        Validate.notNull(testMethod, "TestMethod must be specified");
        ExecutionDecision executionDecision = this.resolveExecutionDecision(this.manager, testMethod);
        if (executionDecision.getDecision() == ExecutionDecision.Decision.DONT_EXECUTE) {
            return;
        }
        this.manager.fire(new Before(testInstance, testMethod, executor));
    }

    @Override
    public void after(Object testInstance, Method testMethod, LifecycleMethodExecutor executor) throws Exception {
        Validate.notNull(testInstance, "TestInstance must be specified");
        Validate.notNull(testMethod, "TestMethod must be specified");
        ExecutionDecision executionDecision = this.resolveExecutionDecision(this.manager, testMethod);
        if (executionDecision.getDecision() == ExecutionDecision.Decision.DONT_EXECUTE) {
            return;
        }
        this.manager.fire(new After(testInstance, testMethod, executor));
    }

    @Override
    public TestResult test(TestMethodExecutor testMethodExecutor) throws Exception {
        Validate.notNull(testMethodExecutor, "TestMethodExecutor must be specified");
        ExecutionDecision executionDecision = this.resolveExecutionDecision(this.manager, testMethodExecutor.getMethod());
        if (executionDecision.getDecision() == ExecutionDecision.Decision.DONT_EXECUTE) {
            return TestResult.skipped(new SkippedTestExecutionException(executionDecision.getReason()));
        }
        final ArrayList result = new ArrayList();
        this.manager.fire(new Test(testMethodExecutor), new NonManagedObserver<Test>(){
            @Inject
            private Instance<TestResult> testResult;

            @Override
            public void fired(Test event) {
                result.add(this.testResult.get());
            }
        });
        return (TestResult)result.get(0);
    }

    @Override
    public <T extends TestLifecycleEvent> void fireCustomLifecycle(T event) throws Exception {
        Validate.notNull(event, "Event must be specified");
        ExecutionDecision executionDecision = this.resolveExecutionDecision(this.manager, event.getTestMethod());
        if (executionDecision.getDecision() == ExecutionDecision.Decision.DONT_EXECUTE) {
            return;
        }
        this.manager.fire(event);
    }

    @Override
    public void shutdown() {
        this.manager.shutdown();
    }

    private ExecutionDecision resolveExecutionDecision(Manager manager, Method testMethod) {
        ExecutionDecision executionDecision;
        block1: {
            TestExecutionDecider decider;
            ExecutionDecision tempExecutionDecision;
            ArrayList<TestExecutionDecider> deciders;
            Validate.notNull(manager, "Manager must be specified.");
            ServiceLoader serviceLoader = manager.resolve(ServiceLoader.class);
            executionDecision = TestExecutionDecider.EXECUTE.decide(testMethod);
            if (serviceLoader == null || (deciders = new ArrayList<TestExecutionDecider>(serviceLoader.all(TestExecutionDecider.class))).size() == 0) break block1;
            Collections.sort(deciders, new TestExecutionDeciderComparator());
            Collections.reverse(deciders);
            Iterator iterator = deciders.iterator();
            while (iterator.hasNext() && ((tempExecutionDecision = (decider = (TestExecutionDecider)iterator.next()).decide(testMethod)) == null || (executionDecision = tempExecutionDecision).getDecision() != ExecutionDecision.Decision.DONT_EXECUTE)) {
            }
        }
        return executionDecision;
    }
}

