/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.daemon.server;

import java.net.InetSocketAddress;
import org.jboss.arquillian.daemon.server.NettyServer;
import org.jboss.arquillian.daemon.server.Server;

public final class Servers {
    public static final int MAX_PORT = 65535;
    public static String METHOD_NAME_CREATE = "create";
    public static Class<?>[] METHOD_PARAMS_CREATE = new Class[]{String.class, Integer.TYPE};

    private Servers() {
        throw new UnsupportedOperationException("No instances permitted");
    }

    public static Server create(String bindAddress, int bindPort) throws IllegalArgumentException {
        InetSocketAddress resolvedInetAddress;
        if (bindPort < 0 || bindPort > 65535) {
            throw new IllegalArgumentException("Bind port must be between 0 and 65535");
        }
        InetSocketAddress inetSocketAddress = resolvedInetAddress = bindAddress == null ? new InetSocketAddress(bindPort) : new InetSocketAddress(bindAddress, bindPort);
        if (resolvedInetAddress.isUnresolved()) {
            throw new IllegalArgumentException("Address \"" + bindAddress + "\" could not be resolved");
        }
        return new NettyServer(resolvedInetAddress);
    }
}

