/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.daemon.protocol.arquillian;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import org.jboss.arquillian.container.spi.client.protocol.metadata.NamedContext;

public class DeploymentContext
extends NamedContext {
    private final InputStream socketInstream;
    private final OutputStream socketOutstream;
    private final BufferedReader reader;
    private final PrintWriter writer;

    private DeploymentContext(String deploymentName, InputStream socketInstream, OutputStream socketOutstream, BufferedReader reader, PrintWriter writer) {
        super(deploymentName);
        this.socketInstream = socketInstream;
        this.socketOutstream = socketOutstream;
        this.reader = reader;
        this.writer = writer;
    }

    public static DeploymentContext create(String deploymentName, InputStream socketInstream, OutputStream socketOutstream, BufferedReader reader, PrintWriter writer) throws IllegalArgumentException {
        if (deploymentName == null || deploymentName.length() == 0) {
            throw new IllegalArgumentException("Deployment name must be specified");
        }
        if (socketInstream == null) {
            throw new IllegalArgumentException("socket instream must be specified");
        }
        if (socketOutstream == null) {
            throw new IllegalArgumentException("socket outstream must be specified");
        }
        if (reader == null) {
            throw new IllegalArgumentException("reader must be specified");
        }
        if (writer == null) {
            throw new IllegalArgumentException("writer must be specified");
        }
        DeploymentContext context = new DeploymentContext(deploymentName, socketInstream, socketOutstream, reader, writer);
        return context;
    }

    public InputStream getSocketInstream() {
        return this.socketInstream;
    }

    public OutputStream getSocketOutstream() {
        return this.socketOutstream;
    }

    public BufferedReader getReader() {
        return this.reader;
    }

    public PrintWriter getWriter() {
        return this.writer;
    }
}

