/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.daemon.protocol.arquillian;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.PrintWriter;
import java.util.logging.Logger;
import org.jboss.arquillian.container.test.spi.ContainerMethodExecutor;
import org.jboss.arquillian.daemon.protocol.arquillian.DeploymentContext;
import org.jboss.arquillian.test.spi.TestMethodExecutor;
import org.jboss.arquillian.test.spi.TestResult;

public class DaemonMethodExecutor
implements ContainerMethodExecutor {
    private static final Logger log = Logger.getLogger(DaemonMethodExecutor.class.getName());
    private static final String SPACE = " ";
    private final DeploymentContext context;

    DaemonMethodExecutor(DeploymentContext context) {
        if (context == null) {
            throw new IllegalArgumentException("deployment context must be specified");
        }
        this.context = context;
    }

    public TestResult invoke(TestMethodExecutor testMethodExecutor) {
        assert (testMethodExecutor != null) : "Test method executor is required";
        StringBuilder builder = new StringBuilder();
        builder.append("CMD test ");
        builder.append(this.context.getName());
        builder.append(SPACE);
        builder.append(testMethodExecutor.getInstance().getClass().getName());
        builder.append(SPACE);
        builder.append(testMethodExecutor.getMethod().getName());
        builder.append("<<EOF");
        String testCommand = builder.toString();
        PrintWriter writer = this.context.getWriter();
        writer.write(testCommand);
        writer.flush();
        try {
            ObjectInputStream response = new ObjectInputStream(new NoCloseInputStream(this.context.getSocketInstream()));
            TestResult testResult = (TestResult)response.readObject();
            response.close();
            return testResult;
        }
        catch (IOException ioe) {
            throw new RuntimeException("Could not get test results", ioe);
        }
        catch (ClassNotFoundException cnfe) {
            throw new RuntimeException("test result not on the client classpath", cnfe);
        }
    }

    private static final class NoCloseInputStream
    extends InputStream {
        private final InputStream delegate;

        NoCloseInputStream(InputStream delegate) {
            assert (delegate != null) : "delegate must be specified";
            this.delegate = delegate;
        }

        public void close() throws IOException {
        }

        public int read() throws IOException {
            return this.delegate.read();
        }

        public int hashCode() {
            return this.delegate.hashCode();
        }

        public int read(byte[] b) throws IOException {
            return this.delegate.read(b);
        }

        public boolean equals(Object obj) {
            return this.delegate.equals(obj);
        }

        public int read(byte[] b, int off, int len) throws IOException {
            return this.delegate.read(b, off, len);
        }

        public long skip(long n) throws IOException {
            return this.delegate.skip(n);
        }

        public String toString() {
            return this.delegate.toString();
        }

        public int available() throws IOException {
            return this.delegate.available();
        }

        public void mark(int readlimit) {
            this.delegate.mark(readlimit);
        }

        public void reset() throws IOException {
            this.delegate.reset();
        }

        public boolean markSupported() {
            return this.delegate.markSupported();
        }
    }
}

