/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.daemon.protocol.arquillian;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jboss.arquillian.container.test.spi.TestDeployment;
import org.jboss.arquillian.container.test.spi.client.deployment.DeploymentPackager;
import org.jboss.arquillian.container.test.spi.client.deployment.ProtocolArchiveProcessor;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ArchivePath;
import org.jboss.shrinkwrap.api.Node;
import org.jboss.shrinkwrap.api.spec.JavaArchive;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum DaemonDeploymentPackager implements DeploymentPackager
{
    INSTANCE;

    private static final Logger log;

    @Override
    public Archive<?> generateDeployment(TestDeployment testDeployment, Collection<ProtocolArchiveProcessor> processors) {
        JavaArchive archive = testDeployment.getApplicationArchive().as(JavaArchive.class);
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Archive before additional packaging: " + archive.toString(true));
        }
        for (Archive<?> auxArchive : testDeployment.getAuxiliaryArchives()) {
            Map<ArchivePath, Node> content = auxArchive.getContent();
            Set<ArchivePath> paths = content.keySet();
            for (ArchivePath path : paths) {
                Node current = archive.get(path);
                Node aux = content.get(path);
                if (current != null) {
                    if (current.getAsset() == null && aux.getAsset() == null) continue;
                    if (current.getAsset() == null && aux.getAsset() != null) {
                        throw new IllegalStateException("Current archive has dir and aux has " + aux.getAsset() + " at " + path);
                    }
                    if (current.getAsset() != null && aux.getAsset() == null) {
                        throw new IllegalStateException("Current archive has " + current.getAsset() + " and aux has dir at " + path);
                    }
                    archive.add(aux.getAsset(), path);
                    continue;
                }
                if (aux.getAsset() == null) continue;
                archive.add(aux.getAsset(), path);
            }
        }
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Archive after additional packaging: " + archive.toString(true));
        }
        return archive;
    }

    static {
        log = Logger.getLogger(DaemonDeploymentPackager.class.getName());
    }
}

