/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.daemon.main;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.util.Arrays;
import java.util.jar.JarFile;
import java.util.logging.Logger;
import java.util.zip.ZipFile;
import org.jboss.arquillian.daemon.main.HackJarModuleLoader;
import org.jboss.arquillian.daemon.main.SecurityActions;
import org.jboss.arquillian.daemon.server.Server;
import org.jboss.arquillian.daemon.server.Servers;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoadException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Main {
    private static final Logger log = Logger.getLogger(Main.class.getName());
    private static final String LOCATION_MODULES = "META-INF/modules";
    private static final String NAME_MODULE_ARQUILLIAN_DAEMON_SERVER = "org.jboss.arquillian.daemon.server";
    private static final String SYSPROP_NAME_BIND_NAME = "arquillian.daemon.bind.name";
    private static final String SYSPROP_NAME_BIND_PORT = "arquillian.daemon.bind.port";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        Class<?> serverClass;
        Object server;
        Class<?> serverFactoryClass;
        Module arquillianDaemonModule;
        ProtectionDomain domain = Main.getProtectionDomain();
        URL thisJar = domain.getCodeSource().getLocation();
        HackJarModuleLoader loader = null;
        ZipFile jar = null;
        try {
            try {
                jar = new JarFile(new File(thisJar.toURI()));
            }
            catch (IOException ioe) {
                throw new RuntimeException("Could not obtain current JAR file: " + thisJar.toExternalForm());
            }
            catch (URISyntaxException e) {
                throw new RuntimeException("Incorrectly-formatted URI to JAR: " + thisJar.toExternalForm());
            }
            loader = new HackJarModuleLoader((JarFile)jar, LOCATION_MODULES);
        }
        finally {
            if (jar != null) {
                try {
                    jar.close();
                }
                catch (IOException ioe) {}
            }
        }
        ModuleIdentifier arquillianDaemonServerId = ModuleIdentifier.create(NAME_MODULE_ARQUILLIAN_DAEMON_SERVER);
        try {
            arquillianDaemonModule = loader.loadModule(arquillianDaemonServerId);
        }
        catch (ModuleLoadException mle) {
            throw new RuntimeException("Could not load Arquillian Daemon module", mle);
        }
        try {
            serverFactoryClass = arquillianDaemonModule.getClassLoader().loadClass(Servers.class.getName());
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        Method createServerMethod = Main.getMethod(serverFactoryClass, Servers.METHOD_NAME_CREATE, Servers.METHOD_PARAMS_CREATE);
        String hostname = null;
        if (args.length >= 1) {
            hostname = args[0];
        }
        hostname = Main.getDefaultValue(SYSPROP_NAME_BIND_NAME, hostname);
        String port = null;
        if (args.length >= 2) {
            port = args[1];
        }
        if ((port = Main.getDefaultValue(SYSPROP_NAME_BIND_PORT, port)) == null || port.length() == 0) {
            port = "0";
        }
        try {
            server = createServerMethod.invoke(null, hostname, Integer.parseInt(port));
        }
        catch (Exception e) {
            throw new RuntimeException("Could not create a new server instance", e);
        }
        try {
            serverClass = arquillianDaemonModule.getClassLoader().loadClass(Server.class.getName());
        }
        catch (ClassNotFoundException cnfe) {
            throw new RuntimeException("Could not get server interface class", cnfe);
        }
        Method startMethod = Main.getMethod(serverClass, "start", Server.METHOD_PARAMS_START);
        try {
            startMethod.invoke(server, new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not start server", e);
        }
        Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

            public void run() {
                log.info("Caught signal, shutting down...");
                Method stopMethod = Main.getMethod(serverClass, "stop", Server.METHOD_PARAMS_STOP);
                try {
                    stopMethod.invoke(server, new Object[0]);
                }
                catch (InvocationTargetException ite) {
                    Throwable cause = ite.getCause();
                    if (cause instanceof IllegalStateException) {
                        return;
                    }
                    throw new RuntimeException("Encountered error invoking stop on server", cause);
                }
                catch (Exception e) {
                    throw new RuntimeException("Could not stop server", e);
                }
            }
        }));
    }

    private static final String getDefaultValue(String sysProp, String suppliedValue) {
        String fromSysProp = SecurityActions.getSystemProperty(sysProp);
        return fromSysProp != null ? fromSysProp : suppliedValue;
    }

    private static Method getMethod(final Class<?> clazz, final String methodName, final Class<?>[] paramTypes) throws SecurityException {
        assert (clazz != null);
        assert (methodName != null && methodName.length() > 0);
        assert (paramTypes != null);
        try {
            if (System.getSecurityManager() == null) {
                return clazz.getMethod(methodName, paramTypes);
            }
            return AccessController.doPrivileged(new PrivilegedAction<Method>(){

                @Override
                public Method run() {
                    try {
                        return clazz.getMethod(methodName, paramTypes);
                    }
                    catch (NoSuchMethodException nsme) {
                        throw new RuntimeException("Could not get method " + methodName + " with types " + Arrays.asList(paramTypes) + " from " + clazz, nsme);
                    }
                }
            });
        }
        catch (NoSuchMethodException nsme) {
            throw new RuntimeException("Could not get method " + methodName + " with types " + Arrays.asList(paramTypes) + " from " + clazz, nsme);
        }
    }

    private static ProtectionDomain getProtectionDomain() throws SecurityException {
        final Class<Main> mainClass = Main.class;
        if (System.getSecurityManager() == null) {
            return mainClass.getProtectionDomain();
        }
        return AccessController.doPrivileged(new PrivilegedAction<ProtectionDomain>(){

            @Override
            public ProtectionDomain run() {
                return mainClass.getProtectionDomain();
            }
        });
    }
}

