/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.daemon.main;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Enumeration;
import java.util.UUID;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.jboss.arquillian.daemon.main.SecurityActions;
import org.jboss.modules.LocalModuleLoader;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoadException;
import org.jboss.modules.ModuleLoader;
import org.jboss.modules.ModuleSpec;

@Deprecated
final class HackJarModuleLoader
extends ModuleLoader {
    private static final String SYSPROP_NAME_TMP_DIR = "java.io.tmpdir";
    private static final String PREFIX_MODULES_DIR = "modules-";
    private final ModuleLoader delegate;
    private final File localModulesLocation;

    public HackJarModuleLoader(JarFile jar, String moduleRoot) throws IllegalArgumentException {
        if (jar == null) {
            throw new IllegalArgumentException("JAR file must be specified");
        }
        if (moduleRoot == null || moduleRoot.length() == 0) {
            throw new IllegalArgumentException("Module root within the JAR must be specified");
        }
        String tempDirName = SecurityActions.getSystemProperty(SYSPROP_NAME_TMP_DIR);
        File tempDir = new File(tempDirName);
        File modulesDir = new File(tempDir, PREFIX_MODULES_DIR + UUID.randomUUID().toString());
        if (!modulesDir.mkdir()) {
            throw new IllegalStateException("Could not create modules directory: " + modulesDir.getAbsolutePath());
        }
        Enumeration<JarEntry> entries = jar.entries();
        while (entries.hasMoreElements()) {
            boolean created;
            String parsedFullFileName;
            int lastDirIndex;
            String name;
            JarEntry entry = entries.nextElement();
            if (entry.isDirectory() || !(name = entry.getName()).startsWith(moduleRoot) || (lastDirIndex = (parsedFullFileName = name.substring(moduleRoot.length() + 1)).lastIndexOf(47)) <= 0) continue;
            String targetRelativeDirName = parsedFullFileName.substring(0, lastDirIndex);
            File targetDir = new File(modulesDir, targetRelativeDirName);
            if (!targetDir.exists() && !(created = targetDir.mkdirs())) {
                throw new IllegalStateException("Could not create target directory: " + targetDir);
            }
            String fileName = parsedFullFileName.substring(lastDirIndex);
            File targetFile = new File(targetDir, fileName);
            HackJarModuleLoader.registerRecursiveDeleteOnExit(targetFile, modulesDir);
            InputStream in = null;
            FileOutputStream out = null;
            try {
                in = jar.getInputStream(entry);
                out = new FileOutputStream(targetFile);
                byte[] buffer = new byte[4096];
                int read = 0;
                while ((read = in.read(buffer, 0, buffer.length)) != -1) {
                    ((OutputStream)out).write(buffer, 0, read);
                }
            }
            catch (IOException e) {
                throw new RuntimeException("Could not write " + entry.getName() + " to " + targetFile.getAbsolutePath(), e);
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException ioe) {}
                }
                if (out == null) continue;
                try {
                    ((OutputStream)out).close();
                }
                catch (IOException ioe) {}
            }
        }
        this.delegate = new LocalModuleLoader(new File[]{modulesDir});
        this.localModulesLocation = modulesDir;
    }

    protected Module preloadModule(ModuleIdentifier identifier) throws ModuleLoadException {
        assert (identifier != null);
        return ModuleLoader.preloadModule(identifier, this.delegate);
    }

    public String toString() {
        return HackJarModuleLoader.class.getSimpleName() + " delegating to modules in " + this.localModulesLocation.getAbsolutePath();
    }

    protected ModuleSpec findModule(ModuleIdentifier moduleIdentifier) throws ModuleLoadException {
        throw new UnsupportedOperationException("All loading should be done via the delegate in preloadModule");
    }

    private static void registerRecursiveDeleteOnExit(final File child, File root) {
        if (System.getSecurityManager() == null) {
            child.deleteOnExit();
        } else {
            AccessController.doPrivileged(new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    child.deleteOnExit();
                    return null;
                }
            });
        }
        File parent = child.getParentFile();
        if (!child.equals(root)) {
            HackJarModuleLoader.registerRecursiveDeleteOnExit(parent, root);
        }
    }
}

