/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.daemon.container.managed;

import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jboss.arquillian.container.spi.client.container.DeployableContainer;
import org.jboss.arquillian.container.spi.client.container.LifecycleException;
import org.jboss.arquillian.daemon.container.common.DaemonDeployableContainerBase;
import org.jboss.arquillian.daemon.container.managed.ManagedDaemonContainerConfiguration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManagedDaemonDeployableContainer
extends DaemonDeployableContainerBase<ManagedDaemonContainerConfiguration>
implements DeployableContainer<ManagedDaemonContainerConfiguration> {
    private static final Logger log = Logger.getLogger(ManagedDaemonDeployableContainer.class.getName());
    private static final String SYSPROP_KEY_JAVA_HOME = "java.home";
    private Thread shutdownHookThread;
    private File serverjarFile;
    private Process remoteProcess;

    @Override
    public Class<ManagedDaemonContainerConfiguration> getConfigurationClass() {
        return ManagedDaemonContainerConfiguration.class;
    }

    @Override
    public void setup(ManagedDaemonContainerConfiguration configuration) {
        super.setup(configuration);
        this.serverjarFile = new File(configuration.getServerJarFile());
    }

    @Override
    public void start() throws LifecycleException {
        Process process;
        File javaHome = new File(SecurityActions.getSystemProperty(SYSPROP_KEY_JAVA_HOME));
        ArrayList<String> command = new ArrayList<String>(10);
        command.add(javaHome.getAbsolutePath() + "/bin/java");
        command.add("-jar");
        command.add(this.serverjarFile.getAbsolutePath());
        InetSocketAddress remoteAddress = this.getRemoteAddress();
        command.add(remoteAddress.getHostString());
        command.add(Integer.toString(remoteAddress.getPort()));
        ProcessBuilder processBuilder = new ProcessBuilder(command);
        processBuilder.redirectErrorStream(true);
        processBuilder.redirectOutput(ProcessBuilder.Redirect.INHERIT);
        try {
            this.remoteProcess = process = processBuilder.start();
        }
        catch (IOException e) {
            throw new LifecycleException("Could not start container", e);
        }
        Runnable shutdownServerRunnable = new Runnable(){

            public void run() {
                if (process != null) {
                    process.destroy();
                    try {
                        process.waitFor();
                    }
                    catch (InterruptedException e) {
                        Thread.interrupted();
                        throw new RuntimeException("Interrupted while awaiting server daemon process termination", e);
                    }
                }
            }
        };
        this.shutdownHookThread = new Thread(shutdownServerRunnable);
        Runtime.getRuntime().addShutdownHook(this.shutdownHookThread);
        super.start();
    }

    @Override
    public void stop() throws LifecycleException {
        try {
            this.getWriter().print("CMD stop");
            this.getWriter().print("<<EOF");
            this.getWriter().flush();
            String response = this.getReader().readLine();
            if (log.isLoggable(Level.FINEST)) {
                log.finest("Response from stop: " + response);
            }
            log.info("Response from stop: " + response);
        }
        catch (IOException ioe) {
            throw new LifecycleException("Unexpected problem encountered during read of the response from stop request", ioe);
        }
        catch (RuntimeException re) {
            throw new LifecycleException("Unexpected problem encountered during stop", re);
        }
        finally {
            super.stop();
        }
        try {
            this.remoteProcess.waitFor();
        }
        catch (InterruptedException ie) {
            Thread.interrupted();
        }
        this.remoteProcess = null;
    }

    private static final class SecurityActions {
        private SecurityActions() {
            throw new UnsupportedOperationException("No instance permitted");
        }

        static String getSystemProperty(final String key) {
            assert (key != null && key.length() > 0) : "key must be specified";
            if (System.getSecurityManager() == null) {
                return System.getProperty(key);
            }
            return AccessController.doPrivileged(new PrivilegedAction<String>(){

                @Override
                public String run() {
                    return System.getProperty(key);
                }
            });
        }
    }
}

