/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.daemon.container.managed;

import java.io.File;
import org.jboss.arquillian.container.spi.ConfigurationException;
import org.jboss.arquillian.container.spi.client.container.ContainerConfiguration;
import org.jboss.arquillian.daemon.container.common.DaemonContainerConfigurationBase;

public class ManagedDaemonContainerConfiguration
extends DaemonContainerConfigurationBase
implements ContainerConfiguration {
    private String serverJarFile;

    public void validate() throws ConfigurationException {
        super.validate();
        if (this.serverJarFile == null || this.serverJarFile.length() == 0) {
            throw new ConfigurationException("\"serverJarFile\" must be specified");
        }
        File file = new File(this.serverJarFile);
        if (!file.exists() || file.isDirectory()) {
            throw new ConfigurationException("Server JAR file must exist and not be a directory: " + file.getAbsolutePath());
        }
    }

    public String getServerJarFile() {
        return this.serverJarFile;
    }

    public void setServerJarFile(String serverJarFile) {
        this.serverJarFile = serverJarFile;
    }
}

