/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.daemon.container.common;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jboss.arquillian.container.spi.client.container.DeployableContainer;
import org.jboss.arquillian.container.spi.client.container.DeploymentException;
import org.jboss.arquillian.container.spi.client.container.LifecycleException;
import org.jboss.arquillian.container.spi.client.protocol.ProtocolDescription;
import org.jboss.arquillian.container.spi.client.protocol.metadata.ProtocolMetaData;
import org.jboss.arquillian.daemon.container.common.DaemonContainerConfigurationBase;
import org.jboss.arquillian.daemon.protocol.arquillian.DaemonProtocol;
import org.jboss.arquillian.daemon.protocol.arquillian.DeploymentContext;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.exporter.ZipExporter;
import org.jboss.shrinkwrap.descriptor.api.Descriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DaemonDeployableContainerBase<CONFIGTYPE extends DaemonContainerConfigurationBase>
implements DeployableContainer<CONFIGTYPE> {
    private static final Logger log = Logger.getLogger(DaemonDeployableContainerBase.class.getName());
    private static final String ERROR_MESSAGE_DESCRIPTORS_UNSUPPORTED = "Descriptor deployment not supported";
    private String currentDeploymentId;
    private InetSocketAddress remoteAddress;
    private Socket socket;
    private OutputStream socketOutstream;
    private InputStream socketInstream;
    private BufferedReader reader;
    private PrintWriter writer;

    @Override
    public void setup(CONFIGTYPE configuration) {
        InetSocketAddress address;
        String remoteHost = ((DaemonContainerConfigurationBase)configuration).getHost();
        String remotePort = ((DaemonContainerConfigurationBase)configuration).getPort();
        this.remoteAddress = address = new InetSocketAddress(remoteHost, Integer.parseInt(remotePort));
    }

    @Override
    public void start() throws LifecycleException {
        try {
            BufferedReader reader;
            InputStream socketInstream;
            PrintWriter writer;
            OutputStream socketOutstream;
            long startTime = System.currentTimeMillis();
            int secondsToWait = 10;
            long acceptableTime = startTime + 10000L;
            Socket socket = null;
            while (true) {
                try {
                    socket = new Socket(this.remoteAddress.getHostString(), this.remoteAddress.getPort());
                    if (!log.isLoggable(Level.FINEST)) break;
                    log.finest("Got connection to " + this.remoteAddress.toString());
                    break;
                }
                catch (ConnectException ce) {
                    long currentTime;
                    if (log.isLoggable(Level.FINEST)) {
                        log.finest("No connection yet available to remote process");
                    }
                    if ((currentTime = System.currentTimeMillis()) > acceptableTime) {
                        throw new LifecycleException("Could not connect to the server at " + this.remoteAddress.getHostString() + ":" + this.remoteAddress.getPort() + " in the allotted " + 10 + "s", ce);
                    }
                    try {
                        Thread.sleep(200L);
                    }
                    catch (InterruptedException e) {
                        Thread.interrupted();
                        throw new RuntimeException("No one should be interrupting us while we're waiting to connect", e);
                    }
                }
            }
            assert (socket != null) : "Socket should have been connected";
            this.socket = socket;
            this.socketOutstream = socketOutstream = socket.getOutputStream();
            this.writer = writer = new PrintWriter((Writer)new OutputStreamWriter(socketOutstream, "UTF-8"), true);
            this.socketInstream = socketInstream = socket.getInputStream();
            this.reader = reader = new BufferedReader(new InputStreamReader(socketInstream));
        }
        catch (IOException ioe) {
            this.closeRemoteResources();
            throw new LifecycleException("Could not open connection to remote process", ioe);
        }
    }

    @Override
    public void stop() throws LifecycleException {
        this.closeRemoteResources();
    }

    @Override
    public ProtocolDescription getDefaultProtocol() {
        return DaemonProtocol.DESCRIPTION;
    }

    @Override
    public final ProtocolMetaData deploy(Archive<?> archive) throws DeploymentException {
        String deploymentId;
        try {
            this.writer.print("DPL ");
            this.writer.flush();
            archive.as(ZipExporter.class).exportTo(this.socketOutstream);
            this.socketOutstream.flush();
            this.writer.write("<<EOF");
            this.writer.flush();
            String response = this.reader.readLine();
            if (!response.startsWith("OK ")) {
                throw new DeploymentException("Did not receive proper response from the server, instead was: " + response);
            }
            if (log.isLoggable(Level.FINEST)) {
                log.finest("Response from deployment: " + response);
            }
            int startIndex = new String("OK DPL ").length();
            deploymentId = response.substring(startIndex);
            if (log.isLoggable(Level.FINER)) {
                log.finer("Got deployment: " + deploymentId);
            }
            this.currentDeploymentId = deploymentId;
        }
        catch (IOException ioe) {
            this.closeRemoteResources();
            throw new DeploymentException("I/O problem encountered during deployment", ioe);
        }
        catch (RuntimeException re) {
            this.closeRemoteResources();
            throw new DeploymentException("Unexpected problem encountered during deployment", re);
        }
        ProtocolMetaData pmd = new ProtocolMetaData();
        DeploymentContext deploymentContext = DeploymentContext.create(deploymentId, this.socketInstream, this.socketOutstream, this.reader, this.writer);
        pmd.addContext(deploymentContext);
        return pmd;
    }

    @Override
    public final void undeploy(Archive<?> archive) throws DeploymentException {
        assert (this.currentDeploymentId != null) : "Deployment name should be set";
        try {
            this.writer.print("CMD undeploy ");
            this.writer.print(this.currentDeploymentId);
            this.writer.write("<<EOF");
            this.writer.flush();
            String response = this.reader.readLine();
            if (!response.startsWith("OK ")) {
                throw new DeploymentException("Did not receive proper response from the server, instead was: " + response);
            }
            if (log.isLoggable(Level.FINEST)) {
                log.finest("Response from undeployment: " + response);
            }
            this.currentDeploymentId = null;
        }
        catch (IOException ioe) {
            this.closeRemoteResources();
            throw new DeploymentException("I/O problem encountered during undeployment", ioe);
        }
        catch (RuntimeException re) {
            this.closeRemoteResources();
            throw new DeploymentException("Unexpected problem encountered during undeployment", re);
        }
    }

    @Override
    public void deploy(Descriptor descriptor) throws DeploymentException {
        throw new UnsupportedOperationException(ERROR_MESSAGE_DESCRIPTORS_UNSUPPORTED);
    }

    @Override
    public void undeploy(Descriptor descriptor) throws DeploymentException {
        throw new UnsupportedOperationException(ERROR_MESSAGE_DESCRIPTORS_UNSUPPORTED);
    }

    protected final InetSocketAddress getRemoteAddress() {
        return this.remoteAddress;
    }

    protected final PrintWriter getWriter() {
        return this.writer;
    }

    protected final BufferedReader getReader() {
        return this.reader;
    }

    private void closeRemoteResources() {
        if (this.reader != null) {
            try {
                this.reader.close();
            }
            catch (IOException ignore) {
                // empty catch block
            }
            this.reader = null;
        }
        if (this.writer != null) {
            this.writer.close();
            this.writer = null;
        }
        if (this.socketOutstream != null) {
            try {
                this.socketOutstream.close();
            }
            catch (IOException ignore) {
                // empty catch block
            }
            this.socketOutstream = null;
        }
        if (this.socketInstream != null) {
            try {
                this.socketInstream.close();
            }
            catch (IOException ignore) {
                // empty catch block
            }
            this.socketInstream = null;
        }
        if (this.socket != null) {
            try {
                this.socket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.socket = null;
        }
    }
}

