/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.core.impl.threading;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.jboss.arquillian.core.api.Injector;
import org.jboss.arquillian.core.api.threading.ContextSnapshot;
import org.jboss.arquillian.core.api.threading.ExecutorService;
import org.jboss.arquillian.core.impl.ManagerImpl;
import org.jboss.arquillian.core.spi.context.Context;
import org.jboss.arquillian.core.spi.context.IdBoundContext;
import org.jboss.arquillian.core.spi.context.NonIdBoundContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ThreadedExecutorService
implements ExecutorService {
    private java.util.concurrent.ExecutorService service;
    private ManagerImpl manager;
    private Injector injector;

    public ThreadedExecutorService(final ManagerImpl manager) {
        this.manager = manager;
        try {
            this.injector = manager.executeInApplicationContext(new Callable<Injector>(){

                @Override
                public Injector call() throws Exception {
                    return manager.resolve(Injector.class);
                }
            });
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public <T> Future<T> submit(Callable<T> task) {
        return this.executor().submit(this.wrap(this.injector.inject(task)));
    }

    @Override
    public ContextSnapshot createSnapshotContext() {
        return ContextualStateSnapshot.from(this.manager);
    }

    private java.util.concurrent.ExecutorService executor() {
        if (this.service == null) {
            this.service = Executors.newCachedThreadPool();
        }
        return this.service;
    }

    private <T> Callable<T> wrap(Callable<T> callable) {
        return new ContextualCallable<T>(callable, this.createSnapshotContext());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ContextualStateSnapshot
    implements ContextSnapshot {
        private Map<Context, Object> activeContexts;

        private static ContextSnapshot from(ManagerImpl manager) {
            List<Context> contexts = manager.getContexts();
            HashMap<Context, Object> activeContexts = new HashMap<Context, Object>();
            for (Context context : contexts) {
                if (!context.isActive()) continue;
                if (context instanceof NonIdBoundContext) {
                    activeContexts.put(context, null);
                    continue;
                }
                activeContexts.put(context, ((IdBoundContext)context).getActiveId());
            }
            return new ContextualStateSnapshot(activeContexts);
        }

        private ContextualStateSnapshot(Map<Context, Object> activeContexts) {
            this.activeContexts = activeContexts;
        }

        @Override
        public void activate() {
            for (Map.Entry<Context, Object> entry : this.activeContexts.entrySet()) {
                if (entry.getKey() instanceof NonIdBoundContext) {
                    ((NonIdBoundContext)entry.getKey()).activate();
                    continue;
                }
                if (!(entry.getKey() instanceof IdBoundContext)) continue;
                ((IdBoundContext)entry.getKey()).activate(entry.getValue());
            }
        }

        @Override
        public void deactivate() {
            for (Map.Entry<Context, Object> entry : this.activeContexts.entrySet()) {
                if (entry.getKey() instanceof NonIdBoundContext) {
                    ((NonIdBoundContext)entry.getKey()).deactivate();
                    continue;
                }
                if (!(entry.getKey() instanceof IdBoundContext)) continue;
                ((IdBoundContext)entry.getKey()).deactivate();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ContextualCallable<T>
    implements Callable<T> {
        private Callable<T> delegate;
        private ContextSnapshot state;

        public ContextualCallable(Callable<T> delegate, ContextSnapshot state) {
            this.delegate = delegate;
            this.state = state;
        }

        @Override
        public T call() throws Exception {
            try {
                this.state.activate();
                T t = this.delegate.call();
                return t;
            }
            finally {
                this.state.deactivate();
            }
        }
    }
}

