/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.container.test.impl.execution;

import org.jboss.arquillian.container.spi.Container;
import org.jboss.arquillian.container.spi.client.deployment.Deployment;
import org.jboss.arquillian.container.test.impl.RunModeUtils;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.core.api.annotation.Observes;
import org.jboss.arquillian.test.spi.event.suite.AfterClass;
import org.jboss.arquillian.test.spi.event.suite.AfterTestLifecycleEvent;
import org.jboss.arquillian.test.spi.event.suite.BeforeClass;
import org.jboss.arquillian.test.spi.event.suite.BeforeTestLifecycleEvent;
import org.jboss.arquillian.test.spi.event.suite.LifecycleEvent;
import org.jboss.arquillian.test.spi.event.suite.TestLifecycleEvent;

public class ClientBeforeAfterLifecycleEventExecuter {
    @Inject
    private Instance<Deployment> deployment;
    @Inject
    private Instance<Container> container;

    public void on(@Observes(precedence=-100) BeforeClass event) throws Throwable {
        this.execute(event);
    }

    public void on(@Observes(precedence=100) AfterClass event) throws Throwable {
        this.execute(event);
    }

    public void on(@Observes(precedence=-100) BeforeTestLifecycleEvent event) throws Throwable {
        if (this.isRunAsClient(event) || this.isLocalContainer()) {
            this.execute(event);
        }
    }

    public void on(@Observes(precedence=100) AfterTestLifecycleEvent event) throws Throwable {
        if (this.isRunAsClient(event) || this.isLocalContainer()) {
            this.execute(event);
        }
    }

    private boolean isRunAsClient(TestLifecycleEvent event) {
        return RunModeUtils.isRunAsClient(this.deployment.get(), event.getTestClass().getJavaClass(), event.getTestMethod());
    }

    private boolean isLocalContainer() {
        return RunModeUtils.isLocalContainer(this.container.get());
    }

    private void execute(LifecycleEvent event) throws Throwable {
        event.getExecutor().invoke();
    }
}

