/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.container.test.impl.client.deployment.tool;

import java.io.File;
import java.lang.reflect.Field;
import java.net.URL;
import org.jboss.arquillian.core.spi.Validate;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ArchivePaths;
import org.jboss.shrinkwrap.api.Node;
import org.jboss.shrinkwrap.api.asset.ArchiveAsset;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.ClassAsset;
import org.jboss.shrinkwrap.api.asset.ClassLoaderAsset;
import org.jboss.shrinkwrap.api.asset.FileAsset;
import org.jboss.shrinkwrap.api.asset.UrlAsset;
import org.jboss.shrinkwrap.api.formatter.Formatter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ToolingDeploymentFormatter
implements Formatter {
    private Class<?> testClass;

    public ToolingDeploymentFormatter(Class<?> testClass) {
        Validate.notNull(testClass, "TestClass must be specified");
        this.testClass = testClass;
    }

    @Override
    public String format(Archive<?> archive) throws IllegalArgumentException {
        StringBuilder xml = new StringBuilder();
        xml.append("<?xml version=\"1.0\"?>\n<deployment").append(" name=\"").append(archive.getName()).append("\"").append(" testclass=\"").append(this.testClass.getName()).append("\"").append(">\n");
        this.formatNode(archive.get(ArchivePaths.root()), xml);
        xml.append("</deployment>").append("\n");
        return xml.toString();
    }

    public void formatNode(Node node, StringBuilder xml) {
        if (node.getAsset() != null) {
            String source = this.findResourceLocation(node.getAsset());
            xml.append("\t<asset").append(" type=\"").append(node.getAsset().getClass().getSimpleName()).append("\"").append(" path=\"").append(node.getPath().get()).append("\"");
            if (source != null) {
                xml.append(" source=\"").append(source).append("\"");
            }
            if (node.getAsset().getClass() == ArchiveAsset.class) {
                xml.append(">");
                xml.append("\n");
                this.formatNode(((ArchiveAsset)node.getAsset()).getArchive().get(ArchivePaths.root()), xml);
                xml.append("</asset>").append("\n");
            } else {
                xml.append("/>").append("\n");
            }
        } else {
            xml.append("\t<asset type=\"Directory\" path=\"").append(node.getPath().get()).append("\"/>\n");
        }
        for (Node child : node.getChildren()) {
            this.formatNode(child, xml);
        }
    }

    private String findResourceLocation(Asset asset) {
        Class<?> assetClass = asset.getClass();
        if (assetClass == FileAsset.class) {
            return this.getInternalFieldValue(File.class, "file", asset).getAbsolutePath();
        }
        if (assetClass == ClassAsset.class) {
            return this.getInternalFieldValue(Class.class, "clazz", asset).getName();
        }
        if (assetClass == UrlAsset.class) {
            return this.getInternalFieldValue(URL.class, "url", asset).toExternalForm();
        }
        if (assetClass == ClassLoaderAsset.class) {
            return this.getInternalFieldValue(String.class, "resourceName", asset);
        }
        return null;
    }

    private <T> T getInternalFieldValue(Class<T> type, String fieldName, Object obj) {
        try {
            Field field = obj.getClass().getDeclaredField(fieldName);
            field.setAccessible(true);
            return (T)field.get(obj);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not extract field " + fieldName + " on " + obj, e);
        }
    }
}

