/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.container.test.impl.client.deployment;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import org.jboss.arquillian.container.test.api.Deployer;
import org.jboss.arquillian.container.test.impl.client.deployment.command.DeployDeploymentCommand;
import org.jboss.arquillian.container.test.impl.client.deployment.command.GetDeploymentCommand;
import org.jboss.arquillian.container.test.impl.client.deployment.command.UnDeployDeploymentCommand;
import org.jboss.arquillian.container.test.spi.command.CommandService;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.core.spi.ServiceLoader;

public class ContainerDeployer
implements Deployer {
    @Inject
    private Instance<ServiceLoader> serviceLoader;

    public void deploy(final String name) {
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                ContainerDeployer.this.getCommandService().execute(new DeployDeploymentCommand(name));
                return null;
            }
        });
    }

    public void undeploy(final String name) {
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                ContainerDeployer.this.getCommandService().execute(new UnDeployDeploymentCommand(name));
                return null;
            }
        });
    }

    public InputStream getDeployment(final String name) {
        return AccessController.doPrivileged(new PrivilegedAction<InputStream>(){

            @Override
            public InputStream run() {
                return new ByteArrayInputStream(ContainerDeployer.this.getCommandService().execute(new GetDeploymentCommand(name)));
            }
        });
    }

    private CommandService getCommandService() {
        ServiceLoader loader = this.serviceLoader.get();
        if (loader == null) {
            throw new IllegalStateException("No " + ServiceLoader.class.getName() + " found in context");
        }
        CommandService service = loader.onlyOne(CommandService.class);
        if (service == null) {
            throw new IllegalStateException("No " + CommandService.class.getName() + " found in context");
        }
        return service;
    }
}

