/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.container.test.impl.client.deployment;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.jboss.arquillian.container.spi.Container;
import org.jboss.arquillian.container.spi.ContainerRegistry;
import org.jboss.arquillian.container.spi.client.deployment.Deployment;
import org.jboss.arquillian.container.spi.client.deployment.DeploymentDescription;
import org.jboss.arquillian.container.spi.client.deployment.DeploymentScenario;
import org.jboss.arquillian.container.spi.client.deployment.DeploymentTargetDescription;
import org.jboss.arquillian.container.spi.event.DeployDeployment;
import org.jboss.arquillian.container.spi.event.DeploymentEvent;
import org.jboss.arquillian.container.spi.event.UnDeployDeployment;
import org.jboss.arquillian.container.test.api.Deployer;
import org.jboss.arquillian.core.api.Event;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.exporter.ZipExporter;

public class ClientDeployer
implements Deployer {
    @Inject
    private Event<DeploymentEvent> event;
    @Inject
    private Instance<ContainerRegistry> containerRegistry;
    @Inject
    private Instance<DeploymentScenario> deploymentScenario;

    public void deploy(String name) {
        DeploymentScenario scenario = this.deploymentScenario.get();
        if (scenario == null) {
            throw new IllegalArgumentException("No deployment scenario in context");
        }
        ContainerRegistry registry = this.containerRegistry.get();
        if (registry == null) {
            throw new IllegalArgumentException("No container registry in context");
        }
        Deployment deployment = scenario.deployment(new DeploymentTargetDescription(name));
        if (deployment == null) {
            throw new IllegalArgumentException("No deployment in context found with name " + name);
        }
        if (deployment.getDescription().managed()) {
            throw new IllegalArgumentException("Could not deploy " + name + " deployment. The deployment is controlled by Arquillian");
        }
        Container container = registry.getContainer(deployment.getDescription().getTarget());
        if (!container.getState().equals((Object)Container.State.STARTED)) {
            throw new IllegalArgumentException("Deployment with name " + name + " could not be deployed. Container " + container.getName() + " must be started first.");
        }
        this.event.fire(new DeployDeployment(container, deployment));
    }

    public void undeploy(String name) {
        DeploymentScenario scenario = this.deploymentScenario.get();
        if (scenario == null) {
            throw new IllegalArgumentException("No deployment scenario in context");
        }
        ContainerRegistry registry = this.containerRegistry.get();
        if (registry == null) {
            throw new IllegalArgumentException("No container registry in context");
        }
        Deployment deployment = scenario.deployment(new DeploymentTargetDescription(name));
        if (deployment == null) {
            throw new IllegalArgumentException("No deployment in context found with name " + name);
        }
        if (deployment.getDescription().managed()) {
            throw new IllegalArgumentException("Could not deploy " + name + " deployment. The deployment is controlled by Arquillian");
        }
        Container container = registry.getContainer(deployment.getDescription().getTarget());
        if (!container.getState().equals((Object)Container.State.STARTED)) {
            throw new IllegalArgumentException("Deployment with name " + name + " could not be undeployed. Container " + container.getName() + " must be still running.");
        }
        this.event.fire(new UnDeployDeployment(container, deployment));
    }

    public InputStream getDeployment(String name) {
        DeploymentScenario scenario = this.deploymentScenario.get();
        if (scenario == null) {
            throw new IllegalArgumentException("No deployment scenario in context");
        }
        Deployment deployment = scenario.deployment(new DeploymentTargetDescription(name));
        if (deployment == null) {
            throw new IllegalArgumentException("No deployment in context found with name " + name);
        }
        DeploymentDescription description = deployment.getDescription();
        if (description.isArchiveDeployment()) {
            Archive<?> archive = description.testable() ? description.getTestableArchive() : description.getArchive();
            return archive.as(ZipExporter.class).exportAsInputStream();
        }
        return new ByteArrayInputStream(description.getDescriptor().exportAsString().getBytes());
    }
}

