/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.container.test.impl.client.container;

import org.jboss.arquillian.config.descriptor.api.ArquillianDescriptor;
import org.jboss.arquillian.container.spi.event.ContainerMultiControlEvent;
import org.jboss.arquillian.container.spi.event.StartSuiteContainers;
import org.jboss.arquillian.container.spi.event.StopSuiteContainers;
import org.jboss.arquillian.core.api.Event;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.core.api.annotation.Observes;
import org.jboss.arquillian.test.spi.event.suite.BeforeClass;

public class ContainerRestarter {
    private int testClassesCount = 0;
    @Inject
    private Event<ContainerMultiControlEvent> controlEvent;
    @Inject
    private Instance<ArquillianDescriptor> configuration;

    public void restart(@Observes BeforeClass event) throws Exception {
        if (this.shouldRestart()) {
            this.controlEvent.fire(new StopSuiteContainers());
            this.controlEvent.fire(new StartSuiteContainers());
        }
    }

    private boolean shouldRestart() {
        ArquillianDescriptor descriptor = this.configuration.get();
        Integer maxTestClasses = descriptor.engine().getMaxTestClassesBeforeRestart();
        if (maxTestClasses == null) {
            return false;
        }
        if (maxTestClasses > 0 && maxTestClasses == this.testClassesCount) {
            this.testClassesCount = 1;
            return true;
        }
        ++this.testClassesCount;
        return false;
    }
}

