/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.container.test.impl.client.container;

import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.jboss.arquillian.container.spi.Container;
import org.jboss.arquillian.container.spi.ContainerRegistry;
import org.jboss.arquillian.container.spi.client.deployment.Deployment;
import org.jboss.arquillian.container.spi.client.deployment.DeploymentScenario;
import org.jboss.arquillian.container.spi.client.deployment.TargetDescription;
import org.jboss.arquillian.container.spi.event.ContainerControlEvent;
import org.jboss.arquillian.container.spi.event.DeployDeployment;
import org.jboss.arquillian.container.spi.event.KillContainer;
import org.jboss.arquillian.container.spi.event.SetupContainer;
import org.jboss.arquillian.container.spi.event.StartContainer;
import org.jboss.arquillian.container.spi.event.StopContainer;
import org.jboss.arquillian.container.spi.event.UnDeployDeployment;
import org.jboss.arquillian.container.test.api.ContainerController;
import org.jboss.arquillian.core.api.Event;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.annotation.Inject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClientContainerController
implements ContainerController {
    private final Logger log = Logger.getLogger(ClientContainerController.class.getName());
    @Inject
    private Event<ContainerControlEvent> event;
    @Inject
    private Instance<ContainerRegistry> containerRegistry;
    @Inject
    private Instance<DeploymentScenario> deploymentScenario;

    @Override
    public void start(String containerQualifier) {
        DeploymentScenario scenario = this.deploymentScenario.get();
        if (scenario == null) {
            throw new IllegalArgumentException("No deployment scenario in context");
        }
        ContainerRegistry registry = this.containerRegistry.get();
        if (registry == null) {
            throw new IllegalArgumentException("No container registry in context");
        }
        if (!this.containerExists(registry.getContainers(), containerQualifier)) {
            throw new IllegalArgumentException("No container found in registry with name " + containerQualifier);
        }
        if (!this.isControllableContainer(registry.getContainers(), containerQualifier)) {
            throw new IllegalArgumentException("Could not start " + containerQualifier + " container. The container life cycle is controlled by Arquillian");
        }
        List<Deployment> managedDeployments = scenario.startupDeploymentsFor(new TargetDescription(containerQualifier));
        Container container = registry.getContainer(new TargetDescription(containerQualifier));
        this.log.info("Manual starting of a server instance");
        this.event.fire(new StartContainer(container));
        for (Deployment d : managedDeployments) {
            if (d.getDescription().managed() && "custom".equalsIgnoreCase(container.getContainerConfiguration().getMode())) {
                throw new IllegalStateException("Trying to deploy managed deployment " + d.getDescription().getName() + " to custom mode container " + container.getName());
            }
            if (d.isDeployed()) continue;
            this.log.info("Automatic deploying of the managed deployment with name " + d.getDescription().getName() + " for the container with name " + container.getName());
            this.event.fire(new DeployDeployment(container, d));
        }
    }

    @Override
    public void start(String containerQualifier, Map<String, String> config) {
        DeploymentScenario scenario = this.deploymentScenario.get();
        if (scenario == null) {
            throw new IllegalArgumentException("No deployment scenario in context");
        }
        ContainerRegistry registry = this.containerRegistry.get();
        if (registry == null) {
            throw new IllegalArgumentException("No container registry in context");
        }
        if (!this.containerExists(registry.getContainers(), containerQualifier)) {
            throw new IllegalArgumentException("No container with the specified name exists");
        }
        if (!this.isControllableContainer(registry.getContainers(), containerQualifier)) {
            throw new IllegalArgumentException("Could not start " + containerQualifier + " container. The container life cycle is controlled by Arquillian");
        }
        List<Deployment> managedDeployments = scenario.startupDeploymentsFor(new TargetDescription(containerQualifier));
        Container container = registry.getContainer(new TargetDescription(containerQualifier));
        for (String name : config.keySet()) {
            container.getContainerConfiguration().overrideProperty(name, config.get(name));
        }
        this.log.info("Manual starting of a server instance with overridden configuration. New configuration: " + container.getContainerConfiguration().getContainerProperties());
        this.event.fire(new SetupContainer(container));
        this.event.fire(new StartContainer(container));
        for (Deployment d : managedDeployments) {
            if (d.isDeployed()) continue;
            this.log.info("Automatic deploying of the managed deployment with name " + d.getDescription().getName() + " for the container with name " + container.getName());
            this.event.fire(new DeployDeployment(container, d));
        }
    }

    @Override
    public void stop(String containerQualifier) {
        DeploymentScenario scenario = this.deploymentScenario.get();
        if (scenario == null) {
            throw new IllegalArgumentException("No deployment scenario in context");
        }
        ContainerRegistry registry = this.containerRegistry.get();
        if (registry == null) {
            throw new IllegalArgumentException("No container registry in context");
        }
        if (!this.containerExists(registry.getContainers(), containerQualifier)) {
            throw new IllegalArgumentException("No container with the specified name exists");
        }
        if (!this.isControllableContainer(registry.getContainers(), containerQualifier)) {
            throw new IllegalArgumentException("Could not stop " + containerQualifier + " container. The container life cycle is controlled by Arquillian");
        }
        Container container = registry.getContainer(new TargetDescription(containerQualifier));
        List<Deployment> managedDeployments = scenario.startupDeploymentsFor(new TargetDescription(containerQualifier));
        for (Deployment d : managedDeployments) {
            if (!d.isDeployed()) continue;
            this.log.info("Automatic undeploying of the managed deployment with name " + d.getDescription().getName() + " from the container with name " + container.getName());
            this.event.fire(new UnDeployDeployment(container, d));
        }
        this.log.info("Manual stopping of a server instance");
        this.event.fire(new StopContainer(container));
    }

    @Override
    public void kill(String containerQualifier) {
        ContainerRegistry registry = this.containerRegistry.get();
        if (registry == null) {
            throw new IllegalArgumentException("No container registry in context");
        }
        if (!this.containerExists(registry.getContainers(), containerQualifier)) {
            throw new IllegalArgumentException("No container with the specified name exists");
        }
        if (!this.isControllableContainer(registry.getContainers(), containerQualifier)) {
            throw new IllegalArgumentException("Could not start " + containerQualifier + " container. The container life cycle is controlled by Arquillian");
        }
        Container container = registry.getContainer(new TargetDescription(containerQualifier));
        this.log.info("Hard killing of a server instance");
        this.event.fire(new KillContainer(container));
    }

    @Override
    public boolean isStarted(String containerQualifier) {
        ContainerRegistry registry = this.containerRegistry.get();
        if (registry == null) {
            throw new IllegalArgumentException("No container registry in context");
        }
        if (!this.containerExists(registry.getContainers(), containerQualifier)) {
            throw new IllegalArgumentException("No container found in registry with name " + containerQualifier);
        }
        Container container = registry.getContainer(new TargetDescription(containerQualifier));
        return container.getState() == Container.State.STARTED;
    }

    protected boolean containerExists(List<Container> containers, String name) {
        for (Container container : containers) {
            if (!container.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    protected boolean isControllableContainer(List<Container> containers, String containerQualifier) {
        for (Container container : containers) {
            String contianerMode = container.getContainerConfiguration().getMode();
            if (!container.getName().equals(containerQualifier) || !"manual".equalsIgnoreCase(contianerMode) && !"custom".equalsIgnoreCase(contianerMode)) continue;
            return true;
        }
        return false;
    }

    protected Event<ContainerControlEvent> getContainerControllerEvent() {
        return this.event;
    }

    protected Instance<ContainerRegistry> getContainerRegistry() {
        return this.containerRegistry;
    }

    protected Instance<DeploymentScenario> getDeploymentScenario() {
        return this.deploymentScenario;
    }
}

