/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.container.impl;

import org.jboss.arquillian.config.descriptor.api.ContainerDef;
import org.jboss.arquillian.config.descriptor.api.ProtocolDef;
import org.jboss.arquillian.container.impl.DefaultServerKillProcessor;
import org.jboss.arquillian.container.impl.MapObject;
import org.jboss.arquillian.container.impl.SecurityActions;
import org.jboss.arquillian.container.spi.Container;
import org.jboss.arquillian.container.spi.ServerKillProcessor;
import org.jboss.arquillian.container.spi.client.container.ContainerConfiguration;
import org.jboss.arquillian.container.spi.client.container.DeployableContainer;
import org.jboss.arquillian.container.spi.client.container.LifecycleException;
import org.jboss.arquillian.container.spi.client.protocol.ProtocolDescription;
import org.jboss.arquillian.container.spi.context.annotation.ContainerScoped;
import org.jboss.arquillian.container.spi.event.container.AfterKill;
import org.jboss.arquillian.container.spi.event.container.AfterSetup;
import org.jboss.arquillian.container.spi.event.container.AfterStart;
import org.jboss.arquillian.container.spi.event.container.AfterStop;
import org.jboss.arquillian.container.spi.event.container.BeforeKill;
import org.jboss.arquillian.container.spi.event.container.BeforeSetup;
import org.jboss.arquillian.container.spi.event.container.BeforeStart;
import org.jboss.arquillian.container.spi.event.container.BeforeStop;
import org.jboss.arquillian.container.spi.event.container.ContainerEvent;
import org.jboss.arquillian.core.api.Event;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.InstanceProducer;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.core.spi.ServiceLoader;
import org.jboss.arquillian.core.spi.Validate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContainerImpl
implements Container {
    @Inject
    private Event<ContainerEvent> event;
    @Inject
    @ContainerScoped
    private InstanceProducer<Container> containerProducer;
    @Inject
    private Instance<ServiceLoader> serviceLoader;
    private DeployableContainer<?> deployableContainer;
    private String name;
    private Container.State state = Container.State.STOPPED;
    private Throwable failureCause;
    private ContainerDef containerConfiguration;

    public ContainerImpl(String name, DeployableContainer<?> deployableContainer, ContainerDef containerConfiguration) {
        Validate.notNull(name, "Name must be specified");
        Validate.notNull(deployableContainer, "DeployableContainer must be specified");
        Validate.notNull(containerConfiguration, "ConfigurationConfiguration must be specified");
        this.name = name;
        this.deployableContainer = deployableContainer;
        this.containerConfiguration = containerConfiguration;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public DeployableContainer<?> getDeployableContainer() {
        return this.deployableContainer;
    }

    @Override
    public ContainerDef getContainerConfiguration() {
        return this.containerConfiguration;
    }

    @Override
    public ContainerConfiguration createDeployableConfiguration() throws Exception {
        ContainerConfiguration config = (ContainerConfiguration)SecurityActions.newInstance(this.deployableContainer.getConfigurationClass(), new Class[0], new Object[0]);
        MapObject.populate(config, this.containerConfiguration.getContainerProperties());
        config.validate();
        return config;
    }

    @Override
    public boolean hasProtocolConfiguration(ProtocolDescription description) {
        for (ProtocolDef protocol : this.containerConfiguration.getProtocols()) {
            if (!description.getName().equals(protocol.getType())) continue;
            return true;
        }
        return false;
    }

    @Override
    public ProtocolDef getProtocolConfiguration(ProtocolDescription description) {
        for (ProtocolDef protocol : this.containerConfiguration.getProtocols()) {
            if (!description.getName().equals(protocol.getType())) continue;
            return protocol;
        }
        return null;
    }

    @Override
    public Container.State getState() {
        return this.state;
    }

    @Override
    public void setState(Container.State state) {
        this.state = state;
    }

    @Override
    public Throwable getFailureCause() {
        return this.failureCause;
    }

    @Override
    public void setup() throws Exception {
        this.event.fire(new BeforeSetup(this.deployableContainer));
        try {
            this.containerProducer.set(this);
            this.deployableContainer.setup(this.createDeployableConfiguration());
            this.setState(Container.State.SETUP);
        }
        catch (Exception e) {
            this.setState(Container.State.SETUP_FAILED);
            this.failureCause = e;
            throw e;
        }
        this.event.fire(new AfterSetup(this.deployableContainer));
    }

    @Override
    public void start() throws LifecycleException {
        this.event.fire(new BeforeStart(this.deployableContainer));
        try {
            this.deployableContainer.start();
            this.setState(Container.State.STARTED);
        }
        catch (LifecycleException e) {
            this.setState(Container.State.STARTED_FAILED);
            this.failureCause = e;
            throw e;
        }
        this.event.fire(new AfterStart(this.deployableContainer));
    }

    @Override
    public void stop() throws LifecycleException {
        this.event.fire(new BeforeStop(this.deployableContainer));
        try {
            this.deployableContainer.stop();
            this.setState(Container.State.STOPPED);
        }
        catch (LifecycleException e) {
            this.setState(Container.State.STOPPED_FAILED);
            this.failureCause = e;
            throw e;
        }
        this.event.fire(new AfterStop(this.deployableContainer));
    }

    @Override
    public void kill() throws Exception {
        this.event.fire(new BeforeKill(this.deployableContainer));
        try {
            this.getServerKillProcessor().kill(this);
            this.setState(Container.State.KILLED);
        }
        catch (Exception e) {
            this.setState(Container.State.KILLED_FAILED);
            this.failureCause = e;
            throw e;
        }
        this.event.fire(new AfterKill(this.deployableContainer));
    }

    private ServerKillProcessor getServerKillProcessor() {
        ServiceLoader loader = this.serviceLoader.get();
        if (loader == null) {
            throw new IllegalStateException("No " + ServiceLoader.class.getName() + " found in context");
        }
        ServerKillProcessor serverKillProcessor = this.serviceLoader.get().onlyOne(ServerKillProcessor.class, DefaultServerKillProcessor.class);
        if (serverKillProcessor == null) {
            throw new IllegalStateException("No " + ServerKillProcessor.class.getName() + " found in context");
        }
        return serverKillProcessor;
    }
}

