/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.config.impl.extension;

import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jboss.arquillian.config.descriptor.api.ArquillianDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertiesParser {
    private static String ARQ_PROPERTY = "arq\\..*";
    private static String ARQ_ENGINE_PROPERTY = "arq\\.engine\\.(.*)";
    private static String ARQ_CONTAINER = "arq\\.container\\.(.*)\\.(.*)";
    private static String ARQ_CONTAINER_CONFIGURATION = "arq\\.container\\.(.*)\\.configuration\\.(.*)";
    private static String ARQ_CONTAINER_PROTOCOL = "arq\\.container\\.(.*)\\.protocol\\.(.*)\\.(.*)";
    private static String ARQ_GROUP = "arq\\.group\\.(.*)\\.(.*)";
    private static String ARQ_GROUP_CONTAINER = "arq\\.group\\.(.*)\\.container\\.(.*)\\.(.*)";
    private static String ARQ_GROUP_CONTAINER_CONFIGURATION = "arq\\.group\\.(.*)\\.container\\.(.*)\\.configuration\\.(.*)";
    private static String ARQ_GROUP_CONTAINER_PROTOCOL = "arq\\.group\\.(.*)\\.container\\.(.*)\\.protocol\\.(.*)\\.(.*)";
    private static String ARQ_DEFAULT_PROTOCOL = "arq\\.defaultprotocol\\.(.*)\\.(.*)";
    private static String ARQ_EXTENSION = "arq\\.extension\\.(.*)\\.(.*)";
    private Handler[] handlers = new Handler[]{new EngineProperty(ARQ_ENGINE_PROPERTY), new ContainerConfiguration(ARQ_CONTAINER_CONFIGURATION), new ContainerProtocol(ARQ_CONTAINER_PROTOCOL), new Container(ARQ_CONTAINER), new Extension(ARQ_EXTENSION), new GroupContainerConfiguration(ARQ_GROUP_CONTAINER_CONFIGURATION), new GroupContainerProtocol(ARQ_GROUP_CONTAINER_PROTOCOL), new GroupContainer(ARQ_GROUP_CONTAINER), new Group(ARQ_GROUP), new DefaultProtocol(ARQ_DEFAULT_PROTOCOL)};

    public void addProperties(ArquillianDescriptor descriptor, Properties properties) {
        if (descriptor == null) {
            throw new IllegalArgumentException("Descriptor must be specified");
        }
        if (properties == null) {
            throw new IllegalArgumentException("Properties must be specified");
        }
        Set<Map.Entry<Object, Object>> filteredProps = this.filterProperties(properties);
        for (Map.Entry<Object, Object> entry : filteredProps) {
            for (Handler handler : this.handlers) {
                if (handler.handle(String.valueOf(entry.getKey()), String.valueOf(entry.getValue()), descriptor)) break;
            }
        }
    }

    private Set<Map.Entry<Object, Object>> filterProperties(Properties properties) {
        HashSet<Map.Entry<Object, Object>> filtered = new HashSet<Map.Entry<Object, Object>>();
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            if (!String.valueOf(entry.getKey()).matches(ARQ_PROPERTY)) continue;
            filtered.add(entry);
        }
        return filtered;
    }

    private abstract class Handler {
        private Pattern expression;

        public Handler(String expression) {
            this.expression = Pattern.compile(expression);
        }

        public boolean handle(String propertyName, String value, ArquillianDescriptor descriptor) {
            Matcher matcher = this.expression.matcher(propertyName);
            if (matcher.matches()) {
                this.handle(matcher, value, descriptor);
                return true;
            }
            return false;
        }

        protected abstract void handle(Matcher var1, String var2, ArquillianDescriptor var3);
    }

    private class EngineProperty
    extends Handler {
        public EngineProperty(String expression) {
            super(expression);
        }

        protected void handle(Matcher matcher, String value, ArquillianDescriptor descriptor) {
            String propertyName = matcher.group(1);
            if ("deploymentExportPath".equals(propertyName)) {
                descriptor.engine().deploymentExportPath(value);
            } else if ("maxTestClassesBeforeRestart".equals(propertyName)) {
                descriptor.engine().maxTestClassesBeforeRestart(Integer.parseInt(value));
            } else {
                throw new RuntimeException("Unknown arquillian engine property[" + propertyName + "] with value[" + value + "]");
            }
        }
    }

    private class ContainerConfiguration
    extends Handler {
        public ContainerConfiguration(String expression) {
            super(expression);
        }

        protected void handle(Matcher matcher, String value, ArquillianDescriptor descriptor) {
            String containerName = matcher.group(1);
            String propertyName = matcher.group(2);
            descriptor.container(containerName).property(propertyName, value);
        }
    }

    private class ContainerProtocol
    extends Handler {
        public ContainerProtocol(String expression) {
            super(expression);
        }

        protected void handle(Matcher matcher, String value, ArquillianDescriptor descriptor) {
            String containerName = matcher.group(1);
            String protocolName = matcher.group(2);
            String propertyName = matcher.group(3);
            descriptor.container(containerName).protocol(protocolName).property(propertyName, value);
        }
    }

    private class Container
    extends Handler {
        public Container(String expression) {
            super(expression);
        }

        protected void handle(Matcher matcher, String value, ArquillianDescriptor descriptor) {
            String containerName = matcher.group(1);
            String attributeName = matcher.group(2);
            if ("mode".equals(attributeName)) {
                descriptor.container(containerName).setMode(value);
            } else if ("default".equals(attributeName)) {
                descriptor.container(containerName).setDefault();
            } else {
                throw new RuntimeException("Unknown arquillian container attribute[" + attributeName + "] with value[" + value + "]");
            }
        }
    }

    private class Extension
    extends Handler {
        public Extension(String expression) {
            super(expression);
        }

        protected void handle(Matcher matcher, String value, ArquillianDescriptor descriptor) {
            String extensionName = matcher.group(1);
            String propertyName = matcher.group(2);
            descriptor.extension(extensionName).property(propertyName, value);
        }
    }

    private class GroupContainerConfiguration
    extends Handler {
        public GroupContainerConfiguration(String expression) {
            super(expression);
        }

        protected void handle(Matcher matcher, String value, ArquillianDescriptor descriptor) {
            String groupName = matcher.group(1);
            String containerName = matcher.group(2);
            String propertyName = matcher.group(3);
            descriptor.group(groupName).container(containerName).property(propertyName, value);
        }
    }

    private class GroupContainerProtocol
    extends Handler {
        public GroupContainerProtocol(String expression) {
            super(expression);
        }

        protected void handle(Matcher matcher, String value, ArquillianDescriptor descriptor) {
            String groupName = matcher.group(1);
            String containerName = matcher.group(2);
            String protocolName = matcher.group(3);
            String propertyName = matcher.group(4);
            descriptor.group(groupName).container(containerName).protocol(protocolName).property(propertyName, value);
        }
    }

    private class GroupContainer
    extends Handler {
        public GroupContainer(String expression) {
            super(expression);
        }

        protected void handle(Matcher matcher, String value, ArquillianDescriptor descriptor) {
            String groupName = matcher.group(1);
            String containerName = matcher.group(2);
            String attributeName = matcher.group(3);
            if ("mode".equals(attributeName)) {
                descriptor.group(groupName).container(containerName).setMode(value);
            } else if ("default".equals(attributeName)) {
                descriptor.group(groupName).container(containerName).setDefault();
            } else {
                throw new RuntimeException("Unknown arquillian container attribute[" + attributeName + "] with value[" + value + "]");
            }
        }
    }

    private class Group
    extends Handler {
        public Group(String expression) {
            super(expression);
        }

        protected void handle(Matcher matcher, String value, ArquillianDescriptor descriptor) {
            String groupName = matcher.group(1);
            String attributeName = matcher.group(2);
            if (!"default".equals(attributeName)) {
                throw new RuntimeException("Unknown arquillian container attribute[" + attributeName + "] with value[" + value + "]");
            }
            descriptor.group(groupName).setGroupDefault();
        }
    }

    private class DefaultProtocol
    extends Handler {
        public DefaultProtocol(String expression) {
            super(expression);
        }

        protected void handle(Matcher matcher, String value, ArquillianDescriptor descriptor) {
            String typeName = matcher.group(1);
            String propertyName = matcher.group(2);
            descriptor.defaultProtocol(typeName).property(propertyName, value);
        }
    }
}

