/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.config.impl.extension;

import java.io.InputStream;
import org.jboss.arquillian.config.descriptor.api.ArquillianDescriptor;
import org.jboss.arquillian.config.impl.extension.ConfigurationSysPropResolver;
import org.jboss.arquillian.config.impl.extension.FileUtils;
import org.jboss.arquillian.config.impl.extension.PropertiesParser;
import org.jboss.arquillian.core.api.InstanceProducer;
import org.jboss.arquillian.core.api.annotation.ApplicationScoped;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.core.api.annotation.Observes;
import org.jboss.arquillian.core.api.event.ManagerStarted;
import org.jboss.shrinkwrap.descriptor.api.Descriptors;

public class ConfigurationRegistrar {
    public static final String ARQUILLIAN_XML_PROPERTY = "arquillian.xml";
    public static final String ARQUILLIAN_XML_DEFAULT = "arquillian.xml";
    public static final String ARQUILLIAN_PROP_PROPERTY = "arquillian.properties";
    public static final String ARQUILLIAN_PROP_DEFAULT = "arquillian.properties";
    @Inject
    @ApplicationScoped
    private InstanceProducer<ArquillianDescriptor> descriptorInst;

    public void loadConfiguration(@Observes ManagerStarted event) {
        InputStream input = FileUtils.loadArquillianXml("arquillian.xml", "arquillian.xml");
        ArquillianDescriptor descriptor = this.resolveDescriptor(input);
        ArquillianDescriptor resolvedDesc = ConfigurationSysPropResolver.resolveSystemProperties(descriptor);
        new PropertiesParser().addProperties(resolvedDesc, FileUtils.loadArquillianProperties("arquillian.properties", "arquillian.properties"));
        this.descriptorInst.set(resolvedDesc);
    }

    private ArquillianDescriptor resolveDescriptor(InputStream input) {
        ArquillianDescriptor descriptor = input != null ? Descriptors.importAs(ArquillianDescriptor.class).fromStream(input) : Descriptors.create(ArquillianDescriptor.class);
        return descriptor;
    }
}

