/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util.log;

import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public abstract class AbstractLogger
implements Logger {
    @Override
    public final Logger getLogger(String name) {
        if (AbstractLogger.isBlank(name)) {
            return this;
        }
        String basename = this.getName();
        String fullname = AbstractLogger.isBlank(basename) || Log.getRootLogger() == this ? name : basename + "." + name;
        Logger logger2 = Log.getLoggers().get(fullname);
        if (logger2 == null) {
            Logger newlog = this.newLogger(fullname);
            logger2 = Log.getMutableLoggers().putIfAbsent(fullname, newlog);
            if (logger2 == null) {
                logger2 = newlog;
            }
        }
        return logger2;
    }

    protected abstract Logger newLogger(String var1);

    private static boolean isBlank(String name) {
        if (name == null) {
            return true;
        }
        int size = name.length();
        for (int i = 0; i < size; ++i) {
            char c = name.charAt(i);
            if (Character.isWhitespace(c)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void debug(String msg, long arg) {
        if (this.isDebugEnabled()) {
            this.debug(msg, new Object[]{new Long(arg)});
        }
    }
}

