/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tamaya.spi;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.tamaya.spi.PropertyValue;

public class PropertyValueBuilder {
    String key;
    String value;
    Map<String, String> contextData = new HashMap<String, String>();

    public PropertyValueBuilder(String key, String value, String source) {
        this.key = Objects.requireNonNull(key);
        this.value = Objects.requireNonNull(value);
        this.contextData.put("_" + key + ".source", Objects.requireNonNull(source));
    }

    public PropertyValueBuilder setContextData(Map<String, String> contextData) {
        this.contextData.clear();
        for (Map.Entry<String, String> en : contextData.entrySet()) {
            this.contextData.put("_" + this.key + '.' + en.getKey(), en.getValue());
        }
        return this;
    }

    public PropertyValueBuilder addContextData(String key, Object value) {
        this.contextData.put("_" + this.key + '.' + key, String.valueOf(Objects.requireNonNull(value, "Meta value is null.")));
        return this;
    }

    public PropertyValue build() {
        return new PropertyValue(this);
    }

    public String toString() {
        return "PropertyValueBuilder{key='" + this.key + '\'' + "value='" + this.value + '\'' + ", contextData=" + this.contextData + '}';
    }
}

